/**********************************************************************************
 *
 * @file    spi_flash.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__

/* Includes ------------------------------------------------------------------ */

#include "utils.h"
#include "ald_spi.h"
#include "ald_gpio.h"

/* Exported Types ------------------------------------------------------------ */
typedef void (*flash_op_cbk_t)(void);
/* Exported Macros ----------------------------------------------------------- */
#define SPI_NSS_PORT  GPIOB
#define SPI_NSS_PIN   GPIO_PIN_0
#define SPI_SCK_PORT  GPIOD
#define SPI_SCK_PIN   GPIO_PIN_3
#define SPI_MOSI_PORT GPIOB
#define SPI_MOSI_PIN  GPIO_PIN_5
#define SPI_MISO_PORT GPIOB
#define SPI_MISO_PIN  GPIO_PIN_4

#define FLASH_CS_SET() (ald_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 1))
#define FLASH_CS_CLR() (ald_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 0))

#define FLASH_WRITE_ENABLE  0x06
#define FLASH_ERASE         0x20 
#define FLASH_CHIP_ERASE    0x60
#define FLASH_PROGRAM       0x02
#define FLASH_READ          0x03
#define FLASH_ID            0x9F
#define FLASH_STATUS        0x05

/* Exported Variables -------------------------------------------------------- */
extern flash_op_cbk_t g_flash_write_cplt;
extern flash_op_cbk_t g_flash_read_cplt;
/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

ald_status_t flash_sector_erase(uint32_t addr);
ald_status_t flash_chip_erase(void);
ald_status_t flash_write(uint32_t addr, void *buf, uint32_t size);
ald_status_t flash_read(uint32_t addr, void *buf, uint32_t size);
ald_status_t flash_read_dma(uint32_t addr, void *data, uint32_t size);
ald_status_t flash_wait_unbusy(void);
uint32_t flash_read_id(void);
void init_mcu_spi(void);

#endif    /*__FLASH_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
