/**********************************************************************************
 *
 * @file    shell_util.h
 * @brief   Header file for shell_util.c
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 #ifndef __SHELL_UTIL_H__
#define __SHELL_UTIL_H__

#include <stdint.h>

#ifndef MAX
    #define MAX(a,b) ((a)>(b)?(a):(b))
#endif /* MAX */
#ifndef MIN
    #define MIN(a,b) ((a)<(b)?(a):(b))
#endif /* MIN */

typedef char (*func_shell_get_ch_t)(void);

/* CMD register data (name nad func addr) */
typedef struct
{
    const char *name;
    int (*func)(int argc, char **argv);
}cmd_func_t;

/* Shell data */
typedef struct
{
    cmd_func_t *cmd_table;
    char *buf;
    uint32_t buf_p;
    uint32_t buf_len;

    uint32_t flag;
}shell_env_t;
enum{
    SHELL_EXIT=0x1,
};

/* Split an input by space */
int split_cmd(char *str, char **args, int len);

/* Get an unsigned int in dec/hex */
uint32_t get_uint(const char *s);

/* Input a char to shell */
void shell_input(char c, shell_env_t *env);

/* Enter shell loop */
void enter_shell_loop(shell_env_t *env);

extern shell_env_t g_shell_env;
#endif /* __SHELL_UTIL_H__ */
