/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"

/* Exported Types ------------------------------------------------------------ */
/* Exported Macros ----------------------------------------------------------- */
#if 0
#define UART_TX_PORT GPIOE
#define UART_TX_PIN  GPIO_PIN_2
#define UART_RX_PORT GPIOE
#define UART_RX_PIN  GPIO_PIN_3
#define UART_X UART2
#else
#define UART_TX_PORT GPIOB
#define UART_TX_PIN  GPIO_PIN_10
#define UART_RX_PORT GPIOB
#define UART_RX_PIN  GPIO_PIN_11
#define UART_X UART0
#endif
/* Exported Variables -------------------------------------------------------- */
extern uart_handle_t g_uart_init;
/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
extern void init_uart(void);
extern void pid_test(void);
extern void fft_test(void);
extern void fir_test(void);
extern void iir_test(void);

#endif    /*__MAIN_H__*/


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
