/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
uart_handle_t g_h_uart = { 0 };
usb_osal_sem_t g_es_shell_rx_sem = NULL;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

int fputc(int ch, FILE *f)
{
    ald_uart_send(&g_h_uart, (uint8_t *)&ch, 1, 1000);
    return ch;
}

/**
  * @brief  Initializate pin of USB.
  * @retval None
  */
void usb_pin_init(void)
{
    gpio_init_t gpio_init_x;

    /* Initialize vbus pin */
    gpio_init_x.mode = GPIO_MODE_OUTPUT;
    gpio_init_x.odos = GPIO_PUSH_PULL;
    gpio_init_x.pupd = GPIO_PUSH_UP;
    gpio_init_x.podrv = GPIO_OUT_DRIVE_6;
    gpio_init_x.nodrv = GPIO_OUT_DRIVE_6;
    gpio_init_x.flt = GPIO_FILTER_DISABLE;
    gpio_init_x.type = GPIO_TYPE_TTL;
    gpio_init_x.func = GPIO_FUNC_5;
    ald_gpio_init(GPIOB, GPIO_PIN_15, &gpio_init_x);

    return;
}
/**
  * @brief  Initializate uart module and pins for uart.
  * @retval None
  */
void uart_init(void)
{
    gpio_init_t gpio_init_x;

    /* Initialize tx pin */
    gpio_init_x.mode = GPIO_MODE_OUTPUT;
    gpio_init_x.odos = GPIO_PUSH_PULL;
    gpio_init_x.pupd = GPIO_PUSH_UP;
    gpio_init_x.podrv = GPIO_OUT_DRIVE_1;
    gpio_init_x.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_init_x.flt = GPIO_FILTER_DISABLE;
    gpio_init_x.type = GPIO_TYPE_TTL;
    gpio_init_x.func = GPIO_FUNC_3;
    ald_gpio_init(GPIOE, GPIO_PIN_2, &gpio_init_x);

    /* Initialize rx pin */
    gpio_init_x.mode = GPIO_MODE_INPUT;
    gpio_init_x.odos = GPIO_PUSH_PULL;
    gpio_init_x.pupd = GPIO_PUSH_UP;
    gpio_init_x.podrv = GPIO_OUT_DRIVE_1;
    gpio_init_x.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_init_x.flt = GPIO_FILTER_DISABLE;
    gpio_init_x.type = GPIO_TYPE_TTL;
    gpio_init_x.func = GPIO_FUNC_3;
    ald_gpio_init(GPIOE, GPIO_PIN_3, &gpio_init_x);

    /* Initialize uart */
    g_h_uart.perh = UART2;
    g_h_uart.init.baud = 115200;
    g_h_uart.init.word_length = UART_WORD_LENGTH_8B;
    g_h_uart.init.stop_bits = UART_STOP_BITS_1;
    g_h_uart.init.parity = UART_PARITY_NONE;
    g_h_uart.init.mode = UART_MODE_UART;
    g_h_uart.init.fctl = UART_HW_FLOW_CTL_DISABLE;
    g_h_uart.tx_cplt_cbk = NULL;
    g_h_uart.rx_cplt_cbk = NULL;
    g_h_uart.error_cbk = NULL;
    ald_uart_init(&g_h_uart);

    SET_BIT(g_h_uart.perh->FCON, UART_FCON_RFRST_MSK);
    SET_BIT(g_h_uart.perh->ICR, UART_ICR_RFTH_MSK);
    ald_uart_interrupt_config(&g_h_uart, UART_IT_RFTH, ENABLE);
    ald_mcu_irq_config(UART2_IRQn, 3, 3, ENABLE);

    return;
}

void usb_hc_low_level_init(void)
{
    ald_pmu_perh_power_config(PMU_POWER_USB, ENABLE);
    ald_cmu_perh_clock_config(CMU_PERH_USB, ENABLE);
    ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
    ald_cmu_usb_clock_config(CMU_USB_CLOCK_SEL_HOSC, CMU_USB_DIV_1);
    ald_rmu_reset_periperal(RMU_PERH_USB);
    ald_mcu_irq_config(USB_INT_IRQn, 2, 2, ENABLE);
    ald_mcu_irq_config(USB_DMA_IRQn, 2, 2, ENABLE);
    usb_pin_init();

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    g_es_shell_rx_sem = usb_osal_sem_create(0);

    uart_init();

    usb_osal_thread_create("shell", 3072, CONFIG_USBHOST_PSC_PRIO + 2, shell_recv_handler, NULL);

    printf("\rSystem start...\r\n");

    usbh_initialize();

    vTaskStartScheduler();

    printf("\rrtos start fail!\r\n");

    while (1)
    {
        ald_delay_ms(1000);
    }
}

/**
  * @}
  */
