/**
  *********************************************************************************
  *
  * @file    .c
  * @brief  Source file
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "support_pdfgen.h"
#include "es_pdf_test.h"
#include "stdio.h"
#include "pdfgen.h"
#include "shell.h"

/* Private Macros ------------------------------------------------------------ */
#define ES_DEFAULT_FILEPATH   "0:/output.pdf"
#define ES_DRAW_POINTS_NUM    (10)

/* Private Variables --------------------------------------------------------- */

/*24位真彩色（红绿蓝）*/
/*FF0000H，红；00FF00，绿；0000FF，蓝*/
static const uint8_t s_fmsh_rgb8b_image[3 * 61 * 27] =
{ 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 253 , 247 , 227 , 165 , 243 , 217 , 142
 , 244 , 218 , 143 , 246 , 220 , 146 , 247 , 223 , 149 , 249 , 224 , 152 , 250 , 227 , 155 , 252 , 229 , 158 , 253 , 232 , 162 , 254 , 247 , 223
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 234 , 172 , 246 , 220 , 140 , 242 , 208 , 110 , 243 , 210 , 112 , 245 , 212 , 115
 , 248 , 216 , 118 , 249 , 219 , 122 , 251 , 221 , 126 , 253 , 224 , 131 , 255 , 244 , 210 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252
 , 255 , 235 , 169 , 255 , 236 , 175 , 249 , 225 , 154 , 243 , 211 , 115 , 245 , 211 , 113 , 247 , 214 , 117 , 249 , 218 , 121 , 251 , 221 , 125
 , 252 , 223 , 129 , 255 , 244 , 210 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 234 , 168 , 255 , 234 , 167 , 255 , 236 , 175
 , 248 , 222 , 143 , 244 , 210 , 112 , 247 , 213 , 115 , 248 , 216 , 119 , 251 , 220 , 123 , 252 , 222 , 127 , 255 , 244 , 209 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 58 , 144 , 219 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0
 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 234 , 167 , 255 , 234 , 166 , 255 , 234 , 168 , 248 , 221 , 144 , 243 , 209 , 110 , 246 , 212 , 114
 , 248 , 215 , 118 , 250 , 219 , 122 , 252 , 222 , 126 , 255 , 244 , 209 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58
 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 182 , 102 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 234 , 166
 , 255 , 234 , 164 , 255 , 233 , 165 , 247 , 220 , 141 , 242 , 208 , 108 , 245 , 212 , 112 , 247 , 214 , 116 , 250 , 218 , 121 , 252 , 222 , 125
 , 255 , 244 , 208 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 219 , 144 , 58 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 234 , 166 , 255 , 233 , 161 , 255 , 232 , 162 , 247 , 219 , 138
 , 241 , 207 , 108 , 244 , 210 , 111 , 247 , 214 , 115 , 249 , 217 , 119 , 251 , 221 , 124 , 255 , 243 , 208 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 58 , 144 , 219 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 102 , 182 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0
 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 254 , 252 , 255 , 234 , 164 , 255 , 232 , 159 , 255 , 231 , 159 , 246 , 218 , 136 , 241 , 205 , 106 , 243 , 209 , 110 , 246 , 213 , 114
 , 249 , 216 , 118 , 251 , 220 , 123 , 255 , 243 , 207 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 58
 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0
 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 144 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 233 , 161 , 255 , 231 , 157
 , 255 , 231 , 156 , 246 , 217 , 133 , 240 , 205 , 105 , 243 , 208 , 109 , 246 , 212 , 113 , 249 , 216 , 117 , 251 , 219 , 122 , 252 , 232 , 169
 , 255 , 253 , 249 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 219 , 144 , 58 , 0 , 58 , 144 , 219 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 58 , 144 , 219
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144
 , 58 , 0 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 232 , 159 , 255 , 230 , 154 , 255 , 230 , 154 , 245 , 215 , 131 , 239 , 204 , 104
 , 242 , 208 , 108 , 245 , 211 , 112 , 248 , 216 , 117 , 250 , 218 , 121 , 251 , 221 , 126 , 254 , 238 , 185 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144
 , 58 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 102 , 182 , 255
 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 0 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252
 , 255 , 231 , 157 , 255 , 230 , 152 , 255 , 229 , 151 , 245 , 215 , 129 , 238 , 203 , 104 , 241 , 207 , 108 , 245 , 211 , 112 , 248 , 215 , 116
 , 250 , 218 , 121 , 253 , 222 , 125 , 255 , 235 , 172 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144
 , 58 , 0 , 0 , 0 , 0 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0
 , 0 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 230 , 154 , 255 , 229 , 150 , 255 , 228 , 149
 , 244 , 214 , 126 , 238 , 202 , 103 , 241 , 207 , 107 , 245 , 211 , 111 , 248 , 215 , 116 , 250 , 218 , 121 , 253 , 221 , 125 , 255 , 235 , 172
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 0
 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0
 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 229 , 152 , 255 , 228 , 147 , 254 , 226 , 147 , 236 , 202 , 106 , 238 , 202 , 103 , 241 , 207 , 107
 , 244 , 210 , 111 , 248 , 215 , 116 , 250 , 218 , 120 , 253 , 221 , 125 , 254 , 234 , 172 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58
 , 0 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 102 , 182 , 255 , 255 , 255 , 255 , 219 , 144
 , 102 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 182 , 102 , 0 , 102
 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 182
 , 102 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 252 , 255 , 229 , 150
 , 255 , 227 , 145 , 254 , 225 , 143 , 233 , 198 , 99 , 238 , 202 , 103 , 241 , 207 , 107 , 244 , 210 , 111 , 248 , 215 , 116 , 250 , 218 , 120
 , 253 , 221 , 125 , 250 , 229 , 168 , 251 , 251 , 251 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 0 , 0 , 0 , 0
 , 0 , 0 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 182 , 102 , 0 , 0 , 0 , 0 , 0 , 0 , 0
 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0
 , 0 , 0 , 102 , 182 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 219 , 144 , 58 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0
 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 58 , 144 , 219 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 254 , 255 , 240 , 193 , 255 , 225 , 143 , 255 , 228 , 148 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 254 , 253 , 255 , 245 , 215 , 253 , 228 , 155 , 248 , 248 , 248 , 254 , 254 , 254 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 251 , 238 , 252 , 252 , 252 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255
 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255}; 

static const struct pdf_info s_test_pdf_info =
{
    .creator = "es_software",
    .producer = "es_software",
    .title = "es_document",
    .author = "es_name",
    .subject = "es_subject",
    .date = "Today"
};

static const uint16_t s_draw_point[ES_DRAW_POINTS_NUM * 2] = {
 50U , 100U ,
100U , 300U ,
150U ,   0U ,
200U , 100U ,
250U , 120U ,
300U , 170U ,
350U , 150U ,
400U ,  50U ,
440U , 400U ,
450U ,  50U ,
};


/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

uint32_t es_pdf_test(char *input_fullpath)
{
    FIL  test_file[1];
    const char *file_path = ES_DEFAULT_FILEPATH;

    struct pdf_doc *pdf = NULL;

    /*打开文件*/
    if ((input_fullpath) && (input_fullpath[0]))
        file_path = (const char *)(input_fullpath);
    else
        printf("use default_fullpath\r\n");

    if (f_open(test_file, file_path, FA_CREATE_ALWAYS | FA_WRITE) != FR_OK)
    {
        es_fatfs_error_handler();
        return 0xFFFFFFFF;
    }

    printf("\r\nstart to generate pdf\r\n");

    /*开始生成pdf。catalog、pages、page对象最后写入文件。其它对象实时写入文件*/
    pdf_save_file_start((struct pdf_info*)&s_test_pdf_info, test_file);

    pdf_set_page_size(500, 1000);

    pdf_append_page(pdf);


    pdf_set_font(pdf, "Times-Roman");
    
    pdf_add_text(pdf, NULL, "essemi", 50, 150, 950, PDF_RGB(255, 0, 0));

    pdf_add_text(pdf, NULL, "Font size position color test", 40, 0, 820, PDF_RGB(0, 0, 0));
    pdf_add_text(pdf, NULL, "Test_string1 0123456789", 30, 30, 775, PDF_RGB(255, 0, 0));
    pdf_add_text(pdf, NULL, "Test_string2 AaBbCcXxYyZz", 25, 40, 735, PDF_RGB(0, 255, 0));
    pdf_add_text(pdf, NULL, "Test_string3 ,;.()\\# !$&^*/%%\'\"",20, 50, 710, PDF_RGB(0, 0, 255));
    
    pdf_add_text(pdf, NULL, "Font change test", 40, 0, 620, PDF_RGB(0, 0, 0));
    pdf_set_font(pdf, "Helvetica");
    pdf_add_text(pdf, NULL, "FONT1:Helvetica", 20, 0, 570, PDF_RGB(0, 0, 0));
    pdf_set_font(pdf, "Courier");
    pdf_add_text(pdf, NULL, "FONT2:Courier", 20, 0, 545, PDF_RGB(0, 0, 0));
    pdf_set_font(pdf, "Times-Roman");
    pdf_add_text(pdf, NULL, "FONT3:Times-Roman", 20, 0, 520, PDF_RGB(0, 0, 0));
    
	pdf_add_text(pdf, NULL, "Line test", 40, 0, 420, PDF_RGB(0, 0, 0));
	
	for(int x = 50;x < 500;x += 50)
	{
		pdf_add_line(pdf, NULL,x, 50, x, 350, 1.0 , PDF_RGB(127, 127, 127));
	}
	
	for(int y = 50;y < 400;y += 50)
	{
		pdf_add_line(pdf, NULL,50, y, 450, y, 1.0 , PDF_RGB(127, 127, 127));
	}

#if 0 /*曲线对应的直线*/	
	for(int i = 0;i < (ES_DRAW_POINTS_NUM - 1);i++)
	{
		pdf_add_line(pdf, NULL, s_draw_point[(i<<1)],
								s_draw_point[(i<<1) + 1],
								s_draw_point[((i + 1)<<1)],
								s_draw_point[((i + 1)<<1) + 1], 1.0 , PDF_RGB(255, 0, 0));
	}
#endif
	
	for(int i = 0;i < (ES_DRAW_POINTS_NUM - 3);i += 3)
	{
		pdf_add_cubic_bezier(pdf ,NULL, s_draw_point[(i<<1)],
										s_draw_point[(i<<1) + 1],
										s_draw_point[((i + 3)<<1)],
										s_draw_point[((i + 3)<<1) + 1],
										s_draw_point[((i + 1)<<1)],
										s_draw_point[((i + 1)<<1) + 1],
										s_draw_point[((i + 2)<<1)],
										s_draw_point[((i + 2)<<1) + 1], 1,PDF_RGB(0, 0, 255));
	}
	
    pdf_append_page(pdf);
	
    pdf_add_text(pdf, NULL, "essemi", 50, 150, 950, PDF_RGB(255, 0, 0));

    pdf_add_text(pdf, NULL, "New page test ok", 40, 0, 820, PDF_RGB(0, 0, 0));
    
    pdf_add_text(pdf, NULL, "Img test", 40, 0, 720, PDF_RGB(0, 0, 0));
	
    pdf_add_rgb24(pdf, NULL, 100, 600, 183, 81, s_fmsh_rgb8b_image, 61, 27);

    pdf_add_text(pdf, NULL, "Graphics test", 40, 0, 450, PDF_RGB(0, 0, 0));
	
    pdf_add_circle(pdf, NULL,  50, 250, 30, 1, PDF_RGB(255, 0, 0), PDF_RGB(255, 255, 255));
    pdf_add_circle(pdf, NULL, 150, 250, 40, 1, PDF_RGB(0, 255, 0), PDF_RGB(255, 255, 255));
    pdf_add_circle(pdf, NULL, 270, 250, 50, 1, PDF_RGB(0, 0, 255), PDF_RGB(255, 255, 255));

    pdf_add_filled_rectangle(pdf, NULL, 200, 350, 40, 30, 1, PDF_RGB(255, 255, 0), PDF_RGB(255, 0, 0));

    pdf_save_file_end((struct pdf_info*)&s_test_pdf_info, test_file);

    if (f_close(test_file) != FR_OK)
        es_fatfs_error_handler();

    printf("\r\npdf generate ok\r\n");

    return 0;
}
QSH_FUN_REG(es_pdf_test, "uint32_t es_pdf_test(char* input_fullpath)");
