/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          09 Nov 2022     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
  
  
/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "FreeRTOS.h"
#include "task.h"
#include "hid_mouse.h"
#include "usbh_core.h"
        
/* Public Variables ---------------------------------------------------------- */
uart_handle_t g_uart_handle = { 0 };

/* Private Macros ------------------------------------------------------------ */ 

/* Private Variables--------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */ 

/* Private function prototypes ----------------------------------------------- */ 

/* Private Function ---------------------------------------------------------- */

/* Public Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_USB
  * @{
  */
int fputc(int ch, FILE *f)
{
    ald_uart_send(&g_uart_handle, (uint8_t *)&ch, 1, 1000);
    return ch;
}

/**
  * @brief  Initializate pin of USB.
  * @retval None
  */
void usb_pin_init(void)
{
    gpio_init_t gpio_config;

    /* Initialize vbus pin */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_6;
    gpio_config.nodrv = GPIO_OUT_DRIVE_6;
    gpio_config.flt = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_TTL;
    gpio_config.func = GPIO_FUNC_5;
    ald_gpio_init(GPIOB, GPIO_PIN_15, &gpio_config);

    return;
}
/**
  * @brief  Initializate uart module and pins for uart.
  * @retval None
  */
void uart_init(void)
{
    gpio_init_t gpio_config;

    /* Initialize tx pin */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.flt = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_TTL;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(GPIOE, GPIO_PIN_2, &gpio_config);

    /* Initialize rx pin */
    gpio_config.mode = GPIO_MODE_INPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.flt = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_TTL;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(GPIOE, GPIO_PIN_3, &gpio_config);

    /* Initialize uart */
    g_uart_handle.perh = UART2;
    g_uart_handle.init.baud = 115200;
    g_uart_handle.init.word_length = UART_WORD_LENGTH_8B;
    g_uart_handle.init.stop_bits = UART_STOP_BITS_1;
    g_uart_handle.init.parity = UART_PARITY_NONE;
    g_uart_handle.init.mode = UART_MODE_UART;
    g_uart_handle.init.fctl = UART_HW_FLOW_CTL_DISABLE;
    g_uart_handle.tx_cplt_cbk = NULL;
    g_uart_handle.rx_cplt_cbk = NULL;
    g_uart_handle.error_cbk = NULL;
    ald_uart_init(&g_uart_handle);
    
    return;
}

void usb_hc_low_level_init(void)
{
    ald_pmu_perh_power_config(PMU_POWER_USB, ENABLE);
    ald_cmu_perh_clock_config(CMU_PERH_USB, ENABLE);
    ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
    ald_cmu_usb_clock_config(CMU_USB_CLOCK_SEL_HOSC, CMU_USB_DIV_1);
    ald_rmu_reset_periperal(RMU_PERH_USB);
    ald_mcu_irq_config(USB_INT_IRQn, 2, 2, ENABLE);
    ald_mcu_irq_config(USB_DMA_IRQn, 2, 2, ENABLE);
    usb_pin_init();
   return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    uart_init();
    printf("\rSystem start...\r\n");
    
    usbh_initialize();
       
    hid_mouse_print_pos();
    vTaskStartScheduler();
    
    while (1) {
        ald_delay_ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
