/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
  
  
/* Includes ----------------------------------------------------------------- */
#include "hid_mouse.h"
#include "usbh_core.h"
#include "usbh_hub.h"
#include "usbh_hid.h"
#include "FreeRTOS.h"
#include "task.h"

/* Public Variables ---------------------------------------------------------- */


/* Private Macros ------------------------------------------------------------ */


/* Private Variables--------------------------------------------------------- */
USB_NOCACHE_RAM_SECTION USB_MEM_ALIGNX uint8_t hid_buffer[64]; 
struct usbh_urb hid_intin_urb;
mouse_event_t mouse_event;

/* Private Constants --------------------------------------------------------- */


/* Private function prototypes ----------------------------------------------- */


/* Private Function ---------------------------------------------------------- */
static void usbh_hid_callback(void *arg, int nbytes)
{
    struct usbh_hid *hid_class = (struct usbh_hid *)arg;

    if (nbytes > 0) {
        for (size_t i = 0; i < nbytes; i++) {
            USB_LOG_RAW("0x%02x ", hid_buffer[i]);
        }
    }
    USB_LOG_RAW("\r\n");
                                         
    usbh_int_urb_fill(&hid_intin_urb, hid_class->intin, hid_buffer, 8, 0, usbh_hid_callback, hid_class);
    usbh_submit_urb(&hid_intin_urb);
}

static void usbh_hid_mouse_test(void *arg)
{
    struct usbh_hid *hid_class = (struct usbh_hid *)usbh_find_class_instance("/dev/input0");
    if (hid_class == NULL) {
        USB_LOG_RAW("do not find /dev/input0\r\n");
        return;
    }

    usbh_int_urb_fill(&hid_intin_urb, hid_class->intin, hid_buffer, 8, 0, usbh_hid_callback, hid_class);
    usbh_submit_urb(&hid_intin_urb);
    return;
}

static void usbh_hid_mouse_test_thread(void *arg)
{
    printf("hid mouse test demo start\r\n");
    while (1) 
    {
        usbh_hid_mouse_test(arg);
        usb_osal_msleep(1000);
    }
}

/* Public Function ---------------------------------------------------------- */ 
void hid_mouse_print_pos(void)
{
    usb_osal_thread_create("usbh_test", 4096, CONFIG_USBHOST_PSC_PRIO + 1, usbh_hid_mouse_test_thread, NULL);
}


/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
