/*
    FreeRTOS V9.0.0 - Copyright (C) 2016 Real Time Engineers Ltd.
    All rights reserved

    VISIT http://www.FreeRTOS.org TO ENSURE YOU ARE USING THE LATEST VERSION.

    This file is part of the FreeRTOS distribution.

    FreeRTOS is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License (version 2) as published by the
    Free Software Foundation >>>> AND MODIFIED BY <<<< the FreeRTOS exception.

    ***************************************************************************
    >>!   NOTE: The modification to the GPL is included to allow you to     !<<
    >>!   distribute a combined work that includes FreeRTOS without being   !<<
    >>!   obliged to provide the source code for proprietary components     !<<
    >>!   outside of the FreeRTOS kernel.                                   !<<
    ***************************************************************************

    FreeRTOS is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE.  Full license text is available on the following
    link: http://www.freertos.org/a00114.html

    ***************************************************************************
     *                                                                       *
     *    FreeRTOS provides completely free yet professionally developed,    *
     *    robust, strictly quality controlled, supported, and cross          *
     *    platform software that is more than just the market leader, it     *
     *    is the industry's de facto standard.                               *
     *                                                                       *
     *    Help yourself get started quickly while simultaneously helping     *
     *    to support the FreeRTOS project by purchasing a FreeRTOS           *
     *    tutorial book, reference manual, or both:                          *
     *    http://www.FreeRTOS.org/Documentation                              *
     *                                                                       *
    ***************************************************************************

    http://www.FreeRTOS.org/FAQHelp.html - Having a problem?  Start by reading
    the FAQ page "My application does not run, what could be wrong?".  Have you
    defined configASSERT()?

    http://www.FreeRTOS.org/support - In return for receiving this top quality
    embedded software for free we request you assist our global community by
    participating in the support forum.

    http://www.FreeRTOS.org/training - Investing in training allows your team to
    be as productive as possible as early as possible.  Now you can receive
    FreeRTOS training directly from Richard Barry, CEO of Real Time Engineers
    Ltd, and the world's leading authority on the world's leading RTOS.

    http://www.FreeRTOS.org/plus - A selection of FreeRTOS ecosystem products,
    including FreeRTOS+Trace - an indispensable productivity tool, a DOS
    compatible FAT file system, and our tiny thread aware UDP/IP stack.

    http://www.FreeRTOS.org/labs - Where new FreeRTOS products go to incubate.
    Come and try FreeRTOS+TCP, our new open source TCP/IP stack for FreeRTOS.

    http://www.OpenRTOS.com - Real Time Engineers ltd. license FreeRTOS to High
    Integrity Systems ltd. to sell under the OpenRTOS brand.  Low cost OpenRTOS
    licenses offer ticketed support, indemnification and commercial middleware.

    http://www.SafeRTOS.com - High Integrity Systems also provide a safety
    engineered and independently SIL3 certified version for use in safety and
    mission critical applications that require provable dependability.

*/


#ifndef FREERTOS_CONFIG_H
#define FREERTOS_CONFIG_H


//Բͬıòͬstdint.hļ
#if defined(__ICCARM__) || defined(__CC_ARM) || defined(__GNUC__)
    #include <stdint.h>
    //extern uint32_t SystemCoreClock;
#endif

//

#define configASSERT(x) 
/************************************************************************
 *               FreeRTOSѡ 
 *********************************************************************/
/* 1RTOSʹռʽ0RTOSʹЭʽʱƬ
 * 
 * עڶϣϵͳԷΪռʽЭʽ֡
 * ЭʽϵͳͷCPUлһ
 * лʱȫȡе
 */
#define configUSE_PREEMPTION					  1

//1ʹʱƬ(Ĭʽʹܵ)
#define configUSE_TIME_SLICING					1		

/* ĳЩFreeRTOSӲַѡһҪִе
 * ͨ÷ضӲķ¼ơⷽ
 * 
 * ͨ÷
 *      1.configUSE_PORT_OPTIMISED_TASK_SELECTION Ϊ 0 Ӳ֧ⷽ
 *      2.FreeRTOSֵ֧Ӳ
 *      3.ȫCʵ֣ЧԵⷽ
 *      4.ǿҪȼĿ
 * ⷽ
 *      1.뽫configUSE_PORT_OPTIMISED_TASK_SELECTIONΪ1
 *      2.һضܹĻָһƼǰ[CLZ]ָ
 *      3.ͨ÷Ч
 *      4.һǿ޶ȼĿΪ32
 * һӲǰָʹõģMCUûЩӲָĻ˺ӦΪ0
 */
#define configUSE_PORT_OPTIMISED_TASK_SELECTION	        1                       
                                                                        
/* 1ʹܵ͹ticklessģʽ0ϵͳģtickжһֱ
 * 迪͹ĵĻܻᵼس⣬Ϊ˯,°취
 * 
 * ط
 *      1.Ӻ
 *      2.סλ˲ɿλ
 *     
 *      1.ͨñ BOOT 0 Ӹߵƽ(3.3V)
 *      2.ϵ磬
 *    
 * 			1.ʹFlyMcuһоƬȻ
 *			STMISP -> оƬ(z)
 */
#define configUSE_TICKLESS_IDLE													0   

/*
 * дʵʵCPUںʱƵʣҲCPUִָƵʣͨΪFclk
 * FclkΪCPUں˵ʱźţ˵cpuƵΪ XX MHz
 * ָʱźţӦģ1/FclkΪcpuʱڣ
 */
#define configCPU_CLOCK_HZ						  (72000000)

//RTOSϵͳжϵƵʡһжϵĴÿжRTOS
#define configTICK_RATE_HZ						  (( TickType_t )1000)

//ʹõȼ
#define configMAX_PRIORITIES					  (32)

//ʹõĶջС
#define configMINIMAL_STACK_SIZE				((unsigned short)128)
  
//ַ
#define configMAX_TASK_NAME_LEN					(16)

 //ϵͳļͣ1ʾΪ16λ޷Σ0ʾΪ32λ޷
#define configUSE_16_BIT_TICKS					0                      

//CPUʹȨͬȼû
#define configIDLE_SHOULD_YIELD					1           

//ö
#define configUSE_QUEUE_SETS					  1    

//֪ͨܣĬϿ
#define configUSE_TASK_NOTIFICATIONS    1   

//ʹûź
#define configUSE_MUTEXES						    1    

//ʹõݹ黥ź                                            
#define configUSE_RECURSIVE_MUTEXES			0   

//Ϊ1ʱʹüź
#define configUSE_COUNTING_SEMAPHORES		1

/* ÿעźϢи */
#define configQUEUE_REGISTRY_SIZE				10                                 
                                                                       
#define configUSE_APPLICATION_TASK_TAG		  0                       
                      

/*****************************************************************
              FreeRTOSڴйѡ                                               
*****************************************************************/
//ֶ֧̬ڴ
#define configSUPPORT_DYNAMIC_ALLOCATION        1    
//֧־̬ڴ
#define configSUPPORT_STATIC_ALLOCATION					0					
//ϵͳܵĶѴС
#define configTOTAL_HEAP_SIZE					((size_t)(36*1024))    


/***************************************************************
             FreeRTOS빳Ӻйصѡ                                            
**************************************************************/
/* 1ʹÿйӣIdle Hookڻص0Կй
 * 
 * һûʵ֣
 * FreeRTOS涨˺ֺͲvoid vApplicationIdleHook(void )
 * ÿڶᱻ
 * ѾɾRTOS񣬿ͷŷǵĶջڴ档
 * ˱뱣֤ԱCPUִ
 * ʹÿйӺCPUʡģʽǺܳ
 * ԵûAPI
 */
#define configUSE_IDLE_HOOK						0      

/* 1ʹʱƬӣTick Hook0ʱƬ
 * 
 * 
 * ʱƬһûʵ֣
 * FreeRTOS涨˺ֺͲvoid vApplicationTickHook(void )
 * ʱƬжϿԵĵ
 * ǳСܴʹöջ
 * ܵԡFromISR"  "FROM_ISRβAPI
 */
 /*xTaskIncrementTickxPortSysTickHandlerжϺбõġˣvApplicationTickHook()ִеʱ̲ܶ*/
#define configUSE_TICK_HOOK						0           

//ʹڴʧܹӺ
#define configUSE_MALLOC_FAILED_HOOK			0 

/*
 * 0ʱöջ⹦ܣʹô˹ 
 * ûṩһջӺʹõĻ
 * ֵΪ12Ϊջⷽ */
#define configCHECK_FOR_STACK_OVERFLOW			0   


/********************************************************************
          FreeRTOSʱ״̬ռйصѡ   
**********************************************************************/
//ʱͳƹ
#define configGENERATE_RUN_TIME_STATS	        0             
 //ÿӻٵ
#define configUSE_TRACE_FACILITY				      0    
/* configUSE_TRACE_FACILITYͬʱΪ1ʱ3
 * prvWriteNameToBuffer()
 * vTaskList(),
 * vTaskGetRunTimeStats()
*/
#define configUSE_STATS_FORMATTING_FUNCTIONS	1                       
                                                                        
                                                                        
/********************************************************************
                FreeRTOSЭйصѡ                                                
*********************************************************************/
//Э̣ЭԺļcroutine.c
#define configUSE_CO_ROUTINES 			          0                 
//Э̵ЧȼĿ
#define configMAX_CO_ROUTINE_PRIORITIES       ( 2 )                   


/***********************************************************************
                FreeRTOSʱйصѡ      
**********************************************************************/
 //ʱ
#define configUSE_TIMERS				            1                              
//ʱȼ
#define configTIMER_TASK_PRIORITY		        (configMAX_PRIORITIES-1)        
//ʱг
#define configTIMER_QUEUE_LENGTH		        10                               
//ʱջС
#define configTIMER_TASK_STACK_DEPTH	      (configMINIMAL_STACK_SIZE*2)    

/************************************************************
            FreeRTOSѡѡ                                                     
************************************************************/
#define INCLUDE_xTaskGetSchedulerState       1                       
#define INCLUDE_vTaskPrioritySet		         1
#define INCLUDE_uxTaskPriorityGet		         1
#define INCLUDE_vTaskDelete				           1
#define INCLUDE_vTaskCleanUpResources	       1
#define INCLUDE_vTaskSuspend			           1
#define INCLUDE_vTaskDelayUntil			         1
#define INCLUDE_vTaskDelay				           1
#define INCLUDE_eTaskGetState			           1
#define INCLUDE_xTimerPendFunctionCall	     1
//#define INCLUDE_xTaskGetCurrentTaskHandle       1
//#define INCLUDE_uxTaskGetStackHighWaterMark     0
//#define INCLUDE_xTaskGetIdleTaskHandle          0


/******************************************************************
            FreeRTOSжйصѡ                                                 
******************************************************************/
#ifdef __NVIC_PRIO_BITS
	#define configPRIO_BITS       		__NVIC_PRIO_BITS
#else
	#define configPRIO_BITS       		4                  
#endif
//жȼ
#define configLIBRARY_LOWEST_INTERRUPT_PRIORITY			15     

//ϵͳɹжȼ
#define configLIBRARY_MAX_SYSCALL_INTERRUPT_PRIORITY	5 

#define configKERNEL_INTERRUPT_PRIORITY 		( configLIBRARY_LOWEST_INTERRUPT_PRIORITY << (8 - configPRIO_BITS) )	/* 240 */

#define configMAX_SYSCALL_INTERRUPT_PRIORITY 	( configLIBRARY_MAX_SYSCALL_INTERRUPT_PRIORITY << (8 - 4) )


/****************************************************************
            FreeRTOSжϷйصѡ                         
****************************************************************/
#define xPortPendSVHandler 	PendSV_Handler
#define vPortSVCHandler 	SVC_Handler


/* ΪʹPercepio TracealyzerҪĶҪʱ configUSE_TRACE_FACILITY Ϊ 0 */
#if ( configUSE_TRACE_FACILITY == 1 )
#include "trcRecorder.h"
#define INCLUDE_xTaskGetCurrentTaskHandle               1   // һѡú TraceԴʹãĬϸֵΪ0 ʾã
#endif


#endif /* FREERTOS_CONFIG_H */

