/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          26 Oct 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "cdc_acm.h"
#include "cdc_acm_serial.h"
#include "usbd_core.h"
#include "usbd_cdc.h"

/* Private Macros ------------------------------------------------------------ */

/* Private function prototypes ----------------------------------------------- */
static void usbd_cdc_acm_int_in(uint8_t ep, uint32_t nbytes);

/* Private Variables --------------------------------------------------------- */
static uint8_t cdc_read_buffer[512] = {0};
static uint8_t cdc_write_buffer[512] = {0};       

/* Public Variables ---------------------------------------------------------- */
/*!< endpoint call back */
struct usbd_endpoint g_cdc_out_ep = {
    .ep_addr = USBD_IF1_AL0_EP0_ADDR,
    .ep_cb = NULL
};

struct usbd_endpoint g_cdc_in_ep = {
    .ep_addr = USBD_IF1_AL0_EP1_ADDR,
    .ep_cb = NULL
};

struct usbd_endpoint g_cdc_int_ep = {
    .ep_addr = USBD_IF0_AL0_EP0_ADDR,
    .ep_cb = usbd_cdc_acm_int_in
};


/* Private Constants --------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  define the callback function for bulk out endpoint.
  * @retval None
  */
void usbd_cdc_acm_int_in(uint8_t ep, uint32_t nbytes)
{
    return;
}

/**
  * @brief  cdc uart recv function
  * @retval Status.
  */
void cdc_acm_recv(void)
{
    uint16_t len = ringbuffer_space_len(cdc_acm_out_ringbuffer);
    
    /* if rx available */
    if (len > usb_ep_out_data_avail(USBD_IF1_AL0_EP0_ADDR)){
        len = usb_ep_out_data_avail(USBD_IF1_AL0_EP0_ADDR);
        len = usbd_read_packet(USBD_IF1_AL0_EP0_ADDR, cdc_read_buffer, len);
        ringbuffer_put(cdc_acm_out_ringbuffer, cdc_read_buffer, len);
    }
    
    return;
}

/**
  * @brief  cdc uart recv function
  * @retval Status.
  */
void cdc_acm_xfer(void)
{
    uint16_t len = ringbuffer_data_len(cdc_acm_in_ringbuffer);
    if (len){        
        len = len > usb_ep_in_data_avail(cmsis_dap_handle.cdc_data_ep[1].ep_addr) ? usb_ep_in_data_avail(cmsis_dap_handle.cdc_data_ep[1].ep_addr) : len;
        len = ringbuffer_get(cdc_acm_in_ringbuffer, cdc_write_buffer, len);
        usbd_write_packet(cmsis_dap_handle.cdc_data_ep[1].ep_addr, cdc_write_buffer, len);
    }
    else{
        /**/
    }
    
    return;
}


/**
  * @brief  vcom schedual
  * @retval NONE.
  */
void vcom_schedual(void)
{
    if (cdc_acm_is_configured()){
        cdc_acm_recv();
        cdc_acm_serial_recv();
        cdc_acm_xfer();
        cdc_acm_serial_xfer();
    }
    
    return;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
