/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __HID_CUSTOM_H__
#define   __HID_CUSTOM_H__

/* Includes ----------------------------------------------------------------- */
#include "stdint.h"


/* Exported Types ----------------------------------------------------------- */

/* Exported Macros ---------------------------------------------------------- */
/*!< custom hid report descriptor size */
#define HID_CUSTOM_REPORT_DESC_SIZE (34)

/* Exported Variables ------------------------------------------------------- */
extern const uint8_t hid_custom_report_desc[HID_CUSTOM_REPORT_DESC_SIZE];
extern struct usbd_endpoint g_hid_custom_1_in_ep;
extern struct usbd_endpoint g_hid_custom_1_out_ep;
extern struct usbd_endpoint g_hid_custom_2_in_ep;
extern struct usbd_endpoint g_hid_custom_2_out_ep;

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------- */
void hid_ringbuffer_init(void);
void hid_custom_1_schedual(void);
void hid_custom_2_schedual(void);

#endif  /*__HID_CUSTOM_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
