/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __CDC_DAP_DEMO_H__
#define   __CDC_DAP_DEMO_H__

/* Includes ----------------------------------------------------------------- */
#include "ringbuffer.h"
#include "usbd_core.h"
#include "usbd_hid.h"
#include "usbd_cdc.h"
#include "hid_custom.h"
#include "winusb_custom.h"
#include "cdc_acm.h"


/* Exported Macros ---------------------------------------------------------- */
/*******************************************************START OF ChryUSB_Configurator Generation*************/


#ifndef WBVAL
#define WBVAL(x) (unsigned char)((x) & 0xFF), (unsigned char)(((x) >> 8) & 0xFF)
#endif


/*!< USBD CONFIG */
#define USBD_VERSION 0x0200
#define USBD_PRODUCT_VERSION 0x0001
#define USBD_VID 0x9528
#define USBD_PID 0x30cc
#define USBD_MAX_POWER 0xfa
#define USBD_LANGID_STRING 1033
#define USBD_CONFIG_DESCRIPTOR_SIZE 162




/*!< USBD ENDPOINT CONFIG */

#define USBD_IF0_AL0_EP0_ADDR 0x81
#define USBD_IF0_AL0_EP0_SIZE 0x40
#define USBD_IF0_AL0_EP0_INTERVAL 0x0a

#define USBD_IF1_AL0_EP0_ADDR 0x02
#define USBD_IF1_AL0_EP0_SIZE 0x40
#define USBD_IF1_AL0_EP0_INTERVAL 0x00

#define USBD_IF1_AL0_EP1_ADDR 0x82
#define USBD_IF1_AL0_EP1_SIZE 0x40
#define USBD_IF1_AL0_EP1_INTERVAL 0x00

#define USBD_IF2_AL0_EP0_ADDR 0x03
#define USBD_IF2_AL0_EP0_SIZE 0x40
#define USBD_IF2_AL0_EP0_INTERVAL 0x00

#define USBD_IF2_AL0_EP1_ADDR 0x83
#define USBD_IF2_AL0_EP1_SIZE 0x40
#define USBD_IF2_AL0_EP1_INTERVAL 0x00

#define USBD_IF3_AL0_EP0_ADDR 0x04
#define USBD_IF3_AL0_EP0_SIZE 0x40
#define USBD_IF3_AL0_EP0_INTERVAL 0x0a

#define USBD_IF3_AL0_EP1_ADDR 0x84
#define USBD_IF3_AL0_EP1_SIZE 0x40
#define USBD_IF3_AL0_EP1_INTERVAL 0x0a

#define USBD_IF4_AL0_EP0_ADDR 0x05
#define USBD_IF4_AL0_EP0_SIZE 0x40
#define USBD_IF4_AL0_EP0_INTERVAL 0x0a

#define USBD_IF4_AL0_EP1_ADDR 0x85
#define USBD_IF4_AL0_EP1_SIZE 0x40
#define USBD_IF4_AL0_EP1_INTERVAL 0x0a


/*!< USBD OTHER SPEED CONFIGURATION ENDPOINT CONFIG */

#define OSC_USBD_IF0_AL0_EP0_SIZE 0x40
#define OSC_USBD_IF0_AL0_EP0_INTERVAL 0x0a

#define OSC_USBD_IF1_AL0_EP0_SIZE 0x200
#define OSC_USBD_IF1_AL0_EP0_INTERVAL 0x00

#define OSC_USBD_IF1_AL0_EP1_SIZE 0x200
#define OSC_USBD_IF1_AL0_EP1_INTERVAL 0x00

#define OSC_USBD_IF2_AL0_EP0_SIZE 0x200
#define OSC_USBD_IF2_AL0_EP0_INTERVAL 0x00

#define OSC_USBD_IF2_AL0_EP1_SIZE 0x200
#define OSC_USBD_IF2_AL0_EP1_INTERVAL 0x00

#define OSC_USBD_IF3_AL0_EP0_SIZE 0x200
#define OSC_USBD_IF3_AL0_EP0_INTERVAL 0x0a

#define OSC_USBD_IF3_AL0_EP1_SIZE 0x200
#define OSC_USBD_IF3_AL0_EP1_INTERVAL 0x0a

#define OSC_USBD_IF4_AL0_EP0_SIZE 0x200
#define OSC_USBD_IF4_AL0_EP0_INTERVAL 0x0a

#define OSC_USBD_IF4_AL0_EP1_SIZE 0x200
#define OSC_USBD_IF4_AL0_EP1_INTERVAL 0x0a


/*!< USBD HID CONFIG */
#define USBD_HID_VERSION 0x0111
#define USBD_HID_COUNTRY_CODE 0
#define USBD_IF3_AL0_HID_REPORT_DESC_SIZE 2
#define USBD_IF4_AL0_HID_REPORT_DESC_SIZE 2

 
/*******************************************************END OF ChryUSB_Configurator Generation*************/


/* Exported Types ----------------------------------------------------------- */
typedef struct
{
    uint8_t  ep_addr;
    uint16_t ep_size;
    uint16_t ep_interval;
}ep_info;

typedef struct
{
    ep_info cdc_control_ep;
    ep_info cdc_data_ep[2];
    ep_info winusb_ep[2];
    ep_info hid_1_ep[2];
    ep_info hid_2_ep[2];
}cmsis_dap_info;

/* Exported Variables ------------------------------------------------------- */
extern cmsis_dap_info cmsis_dap_handle;

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------- */
void cmsis_dap_demo_init(void);

/* Imported Functions ------------------------------------------------------- */
extern uint8_t usbd_force_full_speed(const uint8_t port);
extern uint8_t usbd_get_port_speed(const uint8_t port);

#endif  /*__CDC_DAP_DEMO_H__*/
