/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __CDC_ACM_SERIAL_H__
#define   __CDC_ACM_SERIAL_H__

/* Includes ----------------------------------------------------------------- */
#include "cmsis_dap_demo.h"
#include "ringbuffer.h"

/* Exported Types ----------------------------------------------------------- */

/* Exported Macros ---------------------------------------------------------- */

/* Exported Variables ------------------------------------------------------- */
extern struct ringbuffer cdc_acm_out_ringbuffer[1];
extern struct ringbuffer cdc_acm_in_ringbuffer[1];


/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------- */
uint8_t cdc_acm_is_configured(void);
void cdc_acm_serial_init(void);
void cdc_acm_serial_xfer(void);
void cdc_acm_serial_recv(void);

#endif	/*__CDC_ACM_SERIAL_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
