/**
  *
  * Licensed to the Apache Software Foundation (ASF) under one or more
  * contributor license agreements.  See the NOTICE file distributed with
  * this work for additional information regarding copyright ownership.  The
  * ASF licenses this file to you under the Apache License, Version 2.0 (the
  * "License"); you may not use this file except in compliance with the
  * License.  You may obtain a copy of the License at
  *
  *   http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
  * License for the specific language governing permissions and limitations
  * under the License.
  *
  */
                       
#include "usbd_core.h"
#include "usbd_cdc.h"

/*******************************************************START OF ChryUSB_Configurator Generation*************/
#ifndef WBVAL
#define WBVAL(x) (unsigned char)((x) & 0xFF), (unsigned char)(((x) >> 8) & 0xFF)
#endif


/*!< USBD CONFIG */
#define USBD_VERSION 0x0200
#define USBD_PRODUCT_VERSION 0x0001
#define USBD_VID 0x30cc
#define USBD_PID 0xae08
#define USBD_MAX_POWER 0xfa
#define USBD_LANGID_STRING 1033
#define USBD_CONFIG_DESCRIPTOR_SIZE 75


/*!< USBD ENDPOINT CONFIG */

#define USBD_IF0_AL0_EP0_ADDR 0x83
#define USBD_IF0_AL0_EP0_SIZE 0x08
#define USBD_IF0_AL0_EP0_INTERVAL 0x0a

#define USBD_IF1_AL0_EP0_ADDR 0x01
#define USBD_IF1_AL0_EP0_SIZE 0x40
#define USBD_IF1_AL0_EP0_INTERVAL 0x00

#define USBD_IF1_AL0_EP1_ADDR 0x82
#define USBD_IF1_AL0_EP1_SIZE 0x40
#define USBD_IF1_AL0_EP1_INTERVAL 0x00


/*!< USBD HID CONFIG */


/*!< USBD Descriptor */
const unsigned char usbd_descriptor[] = {   
/********************************************** Device Descriptor */
    0x12,                                       /*!< bLength */
    0x01,                                       /*!< bDescriptorType */
    WBVAL(USBD_VERSION),                        /*!< bcdUSB */
    0xef,                                       /*!< bDeviceClass */
    0x02,                                       /*!< bDeviceSubClass */
    0x01,                                       /*!< bDeviceProtocol */
    0x40,                                       /*!< bMaxPacketSize */
    WBVAL(USBD_VID),                            /*!< idVendor */
    WBVAL(USBD_PID),                            /*!< idProduct */
    WBVAL(USBD_PRODUCT_VERSION),                /*!< bcdDevice */
    0x01,                                       /*!< iManufacturer */
    0x02,                                       /*!< iProduct */
    0x03,                                       /*!< iSerial */
    0x01,                                       /*!< bNumConfigurations */
/********************************************** Config Descriptor */
    0x09,                                       /*!< bLength */
    0x02,                                       /*!< bDescriptorType */
    WBVAL(USBD_CONFIG_DESCRIPTOR_SIZE),         /*!< wTotalLength */
    0x02,                                       /*!< bNumInterfaces */
    0x01,                                       /*!< bConfigurationValue */
    0x00,                                       /*!< iConfiguration */
    0x80,                                       /*!< bmAttributes */
    USBD_MAX_POWER,                             /*!< bMaxPower */
/********************************************** Interface Associate Descriptor */
    0x08,                                       /*!< bLength */
    0x0b,                                       /*!< bDescriptorType */
    0x00,                                       /*!< bFirstInterface */
    0x02,                                       /*!< bInterfaceCount */
    0x02,                                       /*!< bFunctionClass */
    0x02,                                       /*!< bFunctionSubClass */
    0x01,                                       /*!< bFunctionProtocol */
    0x00,                                       /*!< iFunction */
/********************************************** Interface 0 Alternate 0 Descriptor */
    0x09,                                       /*!< bLength */
    0x04,                                       /*!< bDescriptorType */
    0x00,                                       /*!< bInterfaceNumber */
    0x00,                                       /*!< bAlternateSetting */
    0x01,                                       /*!< bNumEndpoints */
    0x02,                                       /*!< bInterfaceClass */
    0x02,                                       /*!< bInterfaceSubClass */
    0x01,                                       /*!< bInterfaceProtocol */
    0x00,                                       /*!< iInterface */
/********************************************** Class Specific Descriptor of CDC ACM Control */
    0x05,                                       /*!< bLength */
    0x24,                                       /*!< bDescriptorType */
    0x00,                                       /*!< bDescriptorSubtype */
    WBVAL(0x0110),                              /*!< bcdCDC */
    0x05,                                       /*!< bLength */
    0x24,                                       /*!< bDescriptorType */
    0x01,                                       /*!< bDescriptorSubtype */
    0x00,                                       /*!< bmCapabilities */
    0x01,                                       /*!< bDataInterface */
    0x04,                                       /*!< bLength */
    0x24,                                       /*!< bDescriptorType */
    0x02,                                       /*!< bDescriptorSubtype */
    0x02,                                       /*!< bmCapabilities */
    0x05,                                       /*!< bLength */
    0x24,                                       /*!< bDescriptorType */
    0x06,                                       /*!< bDescriptorSubtype */
    0x00,                                       /*!< bMasterInterface */
    0x01,                                       /*!< bSlaveInterface0 */
/********************************************** Endpoint 0 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF0_AL0_EP0_ADDR,                      /*!< bEndpointAddress */
    0x03,                                       /*!< bmAttributes */
    WBVAL(USBD_IF0_AL0_EP0_SIZE),               /*!< wMaxPacketSize */
    USBD_IF0_AL0_EP0_INTERVAL,                  /*!< bInterval */
/********************************************** Interface 1 Alternate 0 Descriptor */
    0x09,                                       /*!< bLength */
    0x04,                                       /*!< bDescriptorType */
    0x01,                                       /*!< bInterfaceNumber */
    0x00,                                       /*!< bAlternateSetting */
    0x02,                                       /*!< bNumEndpoints */
    0x0a,                                       /*!< bInterfaceClass */
    0x00,                                       /*!< bInterfaceSubClass */
    0x00,                                       /*!< bInterfaceProtocol */
    0x00,                                       /*!< iInterface */
/********************************************** Class Specific Descriptor of CDC ACM Data */
/********************************************** Endpoint 0 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF1_AL0_EP0_ADDR,                      /*!< bEndpointAddress */
    0x02,                                       /*!< bmAttributes */
    WBVAL(USBD_IF1_AL0_EP0_SIZE),               /*!< wMaxPacketSize */
    USBD_IF1_AL0_EP0_INTERVAL,                  /*!< bInterval */
/********************************************** Endpoint 1 Descriptor */
    0x07,                                       /*!< bLength */
    0x05,                                       /*!< bDescriptorType */
    USBD_IF1_AL0_EP1_ADDR,                      /*!< bEndpointAddress */
    0x02,                                       /*!< bmAttributes */
    WBVAL(USBD_IF1_AL0_EP1_SIZE),               /*!< wMaxPacketSize */
    USBD_IF1_AL0_EP1_INTERVAL,                  /*!< bInterval */
/********************************************** Language ID String Descriptor */
    0x04,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    WBVAL(USBD_LANGID_STRING),                  /*!< wLangID0 */
/********************************************** String 1 Descriptor */
/* EastSoft */
    0x12,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x45, 0x00,                                 /*!< 'E' wcChar0 */
    0x61, 0x00,                                 /*!< 'a' wcChar1 */
    0x73, 0x00,                                 /*!< 's' wcChar2 */
    0x74, 0x00,                                 /*!< 't' wcChar3 */
    0x53, 0x00,                                 /*!< 'S' wcChar4 */
    0x6f, 0x00,                                 /*!< 'o' wcChar5 */
    0x66, 0x00,                                 /*!< 'f' wcChar6 */
    0x74, 0x00,                                 /*!< 't' wcChar7 */
/********************************************** String 2 Descriptor */
/* EastSoft CherryUSB CDC demo */
    0x38,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x45, 0x00,                                 /*!< 'E' wcChar0 */
    0x61, 0x00,                                 /*!< 'a' wcChar1 */
    0x73, 0x00,                                 /*!< 's' wcChar2 */
    0x74, 0x00,                                 /*!< 't' wcChar3 */
    0x53, 0x00,                                 /*!< 'S' wcChar4 */
    0x6f, 0x00,                                 /*!< 'o' wcChar5 */
    0x66, 0x00,                                 /*!< 'f' wcChar6 */
    0x74, 0x00,                                 /*!< 't' wcChar7 */
    0x20, 0x00,                                 /*!< ' ' wcChar8 */
    0x43, 0x00,                                 /*!< 'C' wcChar9 */
    0x68, 0x00,                                 /*!< 'h' wcChar10 */
    0x65, 0x00,                                 /*!< 'e' wcChar11 */
    0x72, 0x00,                                 /*!< 'r' wcChar12 */
    0x72, 0x00,                                 /*!< 'r' wcChar13 */
    0x79, 0x00,                                 /*!< 'y' wcChar14 */
    0x55, 0x00,                                 /*!< 'U' wcChar15 */
    0x53, 0x00,                                 /*!< 'S' wcChar16 */
    0x42, 0x00,                                 /*!< 'B' wcChar17 */
    0x20, 0x00,                                 /*!< ' ' wcChar18 */
    0x43, 0x00,                                 /*!< 'C' wcChar19 */
    0x44, 0x00,                                 /*!< 'D' wcChar20 */
    0x43, 0x00,                                 /*!< 'C' wcChar21 */
    0x20, 0x00,                                 /*!< ' ' wcChar22 */
    0x64, 0x00,                                 /*!< 'd' wcChar23 */
    0x65, 0x00,                                 /*!< 'e' wcChar24 */
    0x6d, 0x00,                                 /*!< 'm' wcChar25 */
    0x6f, 0x00,                                 /*!< 'o' wcChar26 */
/********************************************** String 3 Descriptor */
/* 202210201641 */
    0x1a,                                       /*!< bLength */
    0x03,                                       /*!< bDescriptorType */
    0x32, 0x00,                                 /*!< '2' wcChar0 */
    0x30, 0x00,                                 /*!< '0' wcChar1 */
    0x32, 0x00,                                 /*!< '2' wcChar2 */
    0x32, 0x00,                                 /*!< '2' wcChar3 */
    0x31, 0x00,                                 /*!< '1' wcChar4 */
    0x30, 0x00,                                 /*!< '0' wcChar5 */
    0x32, 0x00,                                 /*!< '2' wcChar6 */
    0x30, 0x00,                                 /*!< '0' wcChar7 */
    0x31, 0x00,                                 /*!< '1' wcChar8 */
    0x36, 0x00,                                 /*!< '6' wcChar9 */
    0x34, 0x00,                                 /*!< '4' wcChar10 */
    0x31, 0x00,                                 /*!< '1' wcChar11 */
/********************************************** Device Qualifier Descriptor */
    0x0a,                                       /*!< bLength */
    0x06,                                       /*!< bDescriptorType */
    WBVAL(USBD_VERSION),                        /*!< bcdUSB */
    0x00,                                       /*!< bDeviceClass */
    0x00,                                       /*!< bDeviceSubClass */
    0x00,                                       /*!< bDeviceProtocol */
    0x40,                                       /*!< bMaxPacketSize0 */
    0x01,                                       /*!< bNumConfigurations */
    0x00,                                       /*!< bReserved */
    0x00
};


/*******************************************************END OF ChryUSB_Configurator Generation*************/

USB_NOCACHE_RAM_SECTION USB_MEM_ALIGNX uint8_t read_buffer[2048];
USB_NOCACHE_RAM_SECTION USB_MEM_ALIGNX uint8_t write_buffer[2048];

volatile uint8_t ep_tx_busy_flag;
volatile uint8_t ep_rx_busy_flag;
volatile uint8_t configed_flag = 0;   
uint32_t num;

#ifdef CONFIG_USB_HS
#define CDC_MAX_MPS 512
#else
#define CDC_MAX_MPS 64
#endif

void usbd_event_handler(uint8_t event)
{
    switch (event) 
	{
        case USBD_EVENT_RESET:
            break;
        case USBD_EVENT_CONNECTED:
            break;
        case USBD_EVENT_DISCONNECTED:
            break;
        case USBD_EVENT_RESUME:
            break;
        case USBD_EVENT_SUSPEND:
            break;
        case USBD_EVENT_CONFIGURED:
		{
            configed_flag = 1;
            USB_LOG_RAW("all configuration finished\r\n");
			
            break;
		}
        case USBD_EVENT_SET_REMOTE_WAKEUP:
            break;
        case USBD_EVENT_CLR_REMOTE_WAKEUP:
            break;

        default:
            break;
    }
}

void usbd_cdc_acm_bulk_out(uint8_t ep, uint32_t nbytes)
{
    ep_rx_busy_flag = 0;
    num = nbytes;
    memcpy(write_buffer, read_buffer, nbytes); 
    
    USB_LOG_RAW("actual out len:%d, ep_rx_busy_flag: %d\r\n", nbytes, ep_rx_busy_flag);
}

void usbd_cdc_acm_bulk_in(uint8_t ep, uint32_t nbytes)
{  
    if ((nbytes % CDC_MAX_MPS) == 0 && nbytes) {
        /* must send zlp */
        usbd_ep_start_write(USBD_IF1_AL0_EP1_ADDR, NULL, 0);
    } else {
        ep_tx_busy_flag = 0;
    }  
    USB_LOG_RAW("actual in len:%d, ep_tx_busy_flag: %d\r\n", nbytes, ep_tx_busy_flag);
}

void usbd_cdc_acm_int_in(uint8_t ep, uint32_t nbytes)
{
    USB_LOG_RAW("cdc control");
}

/*!< endpoint call back */
struct usbd_endpoint cdc_out_ep = {
    .ep_addr = USBD_IF1_AL0_EP0_ADDR,
    .ep_cb = usbd_cdc_acm_bulk_out
};

struct usbd_endpoint cdc_in_ep = {
    .ep_addr = USBD_IF1_AL0_EP1_ADDR,
    .ep_cb = usbd_cdc_acm_bulk_in
};

struct usbd_endpoint cdc_int_ep = {
    .ep_addr = USBD_IF0_AL0_EP0_ADDR,
    .ep_cb = usbd_cdc_acm_int_in
};

/* function ------------------------------------------------------------------*/
volatile struct cdc_line_coding g_line_code = {0};
void usbd_cdc_acm_set_line_coding(uint8_t intf, struct cdc_line_coding *line_coding)
{
    if (intf == 0)
    {
        g_line_code.bCharFormat = line_coding->bCharFormat; 
        g_line_code.bParityType = line_coding->bParityType;
        g_line_code.bDataBits = line_coding->bDataBits;
        g_line_code.dwDTERate = line_coding->dwDTERate;
    }
}

void usbd_cdc_acm_get_line_coding(uint8_t intf, struct cdc_line_coding *line_coding)
{
    if (intf == 0)
    {
        line_coding->dwDTERate = g_line_code.dwDTERate;
        line_coding->bDataBits = g_line_code.bDataBits;
        line_coding->bParityType = g_line_code.bParityType;
        line_coding->bCharFormat = g_line_code.bCharFormat;
    }
}

struct usbd_interface intf0;
struct usbd_interface intf1;

void cdc_acm_init(void)
{
    usbd_desc_register(usbd_descriptor);
    usbd_add_interface(usbd_cdc_acm_init_intf(&intf0));
    usbd_add_interface(usbd_cdc_acm_init_intf(&intf1)); 
    usbd_add_endpoint(&cdc_out_ep);
    usbd_add_endpoint(&cdc_in_ep);
    usbd_add_endpoint(&cdc_int_ep);
    usbd_initialize();
    while (configed_flag == 0);
}

void usbd_cdc_acm_read_packet()
{
    ep_rx_busy_flag = 1;
    usbd_ep_start_read(USBD_IF1_AL0_EP0_ADDR, read_buffer, 2048);
    while(ep_rx_busy_flag);
}

void usbd_cdc_acm_write_packet(uint32_t n)
{
    ep_tx_busy_flag = 1;
    usbd_ep_start_write(USBD_IF1_AL0_EP1_ADDR, write_buffer, n);
    while(ep_tx_busy_flag);
}

void cdc_acm_test(void)
{
    usbd_cdc_acm_read_packet();
    usbd_cdc_acm_write_packet(num);
}

/*******************************************************END OF FILE*************/
