/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
#include "boot.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
uart_handle_t g_h_uart;

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initialize the UART
  * @retval None
  */
void uart0_init(void)
{
	gpio_init_t gpio;
	
	/* Initialize tx pin */
	gpio.mode  = GPIO_MODE_OUTPUT;
	gpio.odos  = GPIO_PUSH_PULL;
	gpio.pupd  = GPIO_PUSH_UP;
	gpio.podrv = GPIO_OUT_DRIVE_6;
	gpio.nodrv = GPIO_OUT_DRIVE_6;
	gpio.flt   = GPIO_FILTER_DISABLE;
	gpio.type  = GPIO_TYPE_CMOS;
	gpio.func  = GPIO_FUNC_3;
	ald_gpio_init(GPIOB, GPIO_PIN_10, &gpio);

	/* Initialize rx pin */
	gpio.mode  = GPIO_MODE_INPUT;
	gpio.odos  = GPIO_PUSH_PULL;
	gpio.pupd  = GPIO_PUSH_UP;
	gpio.podrv = GPIO_OUT_DRIVE_6;
	gpio.nodrv = GPIO_OUT_DRIVE_6;
	gpio.flt   = GPIO_FILTER_DISABLE;
	gpio.type  = GPIO_TYPE_CMOS;
	gpio.func  = GPIO_FUNC_3;
	ald_gpio_init(GPIOB, GPIO_PIN_11, &gpio);

	/* Initialize uart */
	g_h_uart.perh             = UART0;
	g_h_uart.init.baud        = 115200;
	g_h_uart.init.word_length = UART_WORD_LENGTH_8B;
	g_h_uart.init.stop_bits   = UART_STOP_BITS_1;
	g_h_uart.init.parity      = UART_PARITY_NONE;
	g_h_uart.init.mode        = UART_MODE_UART;
	g_h_uart.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
	g_h_uart.tx_cplt_cbk      = NULL;
	g_h_uart.rx_cplt_cbk      = NULL;
	g_h_uart.error_cbk        = NULL;
	ald_uart_init(&g_h_uart);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	/* Enable peripheral clock */ 
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* Enable uart interrupt */
	ald_mcu_irq_config(UART0_IRQn, 1, 3, ENABLE);

	uart0_init();
	boot_enter(&g_h_uart);
	return 0;
}

/**
  * @}
  */
/**
  * @}
  */
