/**
  ********************************************************************************
  *
  * @file    boot_conf.h
  * @brief   Head file of boot flash module.
  *
  * @version V1.0
  * @date    31 Dec 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          01 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#ifndef __BOOT_CONF_H__
#define __BOOT_CONF_H__
/* Includes ------------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#define BOOT_FLASH_S        0x00000
#define BOOT_FLASH_E        0x07FFF
#define APP_FLASH_S         0x08000
#define APP_FLASH_E         0x7FFFF
#define APP_FLASH_INFO_S    0x77FF8
#define APP_FLASH_INFO_E    0x77FFF
#define APP_FLASH_SIZE      (APP_FLASH_E - APP_FLASH_S)
#define APP_FLASH_PAGE_SIZE 0x400
#define APP_RUN_RAM_S       0x20004000
#define APP_RUN_RAM_E       0x20018000
#define OFFSET_VTOR_RAM     0x20004000
#define OFFSET_VTOR_FLASH   APP_FLASH_S
#define APP_LAST_PAGE       ((APP_FLASH_E-APP_FLASH_S)/APP_FLASH_PAGE_SIZE)

/* CRC&APP_LEN address in flash */
#define ADDR_CHECK_APP_FLASH_CRC_LEN    (APP_FLASH_INFO_S + 4)
#define ADDR_CHECK_APP_FLASH_CRC_START  (APP_FLASH_S)


/* Exported Types ------------------------------------------------------------ */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
#endif
