/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          22 Feb  2023    shicc           version:1.0.1
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
uint8_t g_rx_buf[64];
uint16_t g_rx_len = sizeof(g_rx_buf);
uint16_t g_rx_i = 0U;
uint8_t g_flag = 0U;

uint16_t g_frame_timer;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();

    /* the time interval of received adjacent bytes in the same frame is more than expected, reset rx FIFO */
    if (g_frame_timer != 0)
    {
        g_frame_timer--;

        if (g_frame_timer == 0)
        {
            g_rx_i = 0;

            md_uart_set_abrmod(UART0, 1);
            md_uart_enable_abr(UART0);
        }
    }

    return;
}

#ifdef ALD_DMA
/**
  * @brief  DMA IRQ#66 handler
  * @retval None
  */
void DMA_Handler(void)
{
    ald_dma_irq_handler();
}
#endif  /*   */

/**
  * @brief  UART IRQ handler
  * @retval None
  */
void UART0_Handler(void)
{
    uint16_t cnt;

    if (md_uart_mask_it_rfth(UART0))
    {
        md_uart_clear_flag_rfth(UART0);

        cnt = 4000;

        while (!md_uart_is_active_flag_rfempty(UART0) && (--cnt))
        {
            g_rx_buf[g_rx_i++] = md_uart_recv_data8(UART0);

            /* assign timer to default when MCU receive each byte */
            g_frame_timer = FRAME_INTERVAL;

            if(g_rx_buf[0] != 0x3F)
            {
                g_rx_i = 0;

                md_uart_set_abrmod(UART0, 1);
                md_uart_enable_abr(UART0);
            }

            if (g_rx_i >= 8)
            {
                g_rx_i = 0;
                g_flag = 1;
            }

            if (g_rx_i >= g_rx_len)
                g_rx_i = 0;
        }
    }

    return;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
