/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    30 Oct 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          22 Feb  2023    shicc           version:1.0.1
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__
/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"

/* Exported Types ------------------------------------------------------------ */
/* Exported Macros ----------------------------------------------------------- */
#define LED_PORT GPIOC
#define LED_PIN MD_GPIO_PIN_12

#define UART_TX_PORT   GPIOB
#define UART_TX_PIN    MD_GPIO_PIN_10
#define UART_RX_PORT   GPIOB
#define UART_RX_PIN    MD_GPIO_PIN_11

#define POS_ACK 0x79
#define NEG_ACK 0x1F

#define APP_ADDR 0x0000
#define BOOT_ADDR 0x7E000 
#define CRC_CAL_PAGE_ADDR        0x0007DC00
#define GO_APP      0xFFFFFFFE
#define GO_BOOT     0xFFFFFFFD

#define FRAME_INTERVAL   500    /* the longest time interval between received cmd frame and execution result frame */

/* Exported Variables -------------------------------------------------------- */
extern uint8_t g_rx_buf[64];
extern uint16_t g_rx_len;
extern uint16_t g_rx_i;
extern uint8_t g_flag;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
#endif /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
