/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include "main.h"


/* Public Variables ---------------------------------------------------------- */
uint32_t  len_hex;
/* Public Function ---------------------------------------------------------- */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables--------------------------------------------------------- */
static md_i2c_init_t s_i2c_init;

/* Private Constants --------------------------------------------------------- */


/* Private function prototypes ----------------------------------------------- */


/* Private Function ---------------------------------------------------------- */
/**
  * @brief  init pins used fot uart communication.
  * @param  None
  * @retval None
  */
void i2c1_pins_init(void)
{
    md_gpio_init_t gpio_config;

    /* Initialize scl pin */
    gpio_config.mode  = MD_GPIO_MODE_INPUT;
    gpio_config.odos  = MD_GPIO_OPEN_DRAIN;
    gpio_config.pupd  = MD_GPIO_PUSH_UP;
    gpio_config.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_config.type  = MD_GPIO_TYPE_CMOS;
    gpio_config.func  = MD_GPIO_FUNC_5;
    md_gpio_init(GPIOB, MD_GPIO_PIN_10, &gpio_config);

    /* Initialize sda pin */
    gpio_config.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_config.odos  = MD_GPIO_OPEN_DRAIN;
    gpio_config.pupd  = MD_GPIO_PUSH_UP;
    gpio_config.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_config.type  = MD_GPIO_TYPE_CMOS;
    gpio_config.func  = MD_GPIO_FUNC_5;
    md_gpio_init(GPIOB, MD_GPIO_PIN_11, &gpio_config);

    return;
}


/* Public Variables ---------------------------------------------------------- */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HRC_6, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Init communication parameters */
    i2c1_pins_init();
    /* slave address: 0x2D, 7 bits address, 100K, SCL with auto stretch, rx_fifo: 0 byte, tx_fifo: 1 byte */
    s_i2c_init.clk_speed    = MD_I2C_STANDARD_MODE_MAX_CLK;
    s_i2c_init.addr_mode    = MD_I2C_ADDR_7BIT;
    s_i2c_init.own_addr2    = 0x0;
    s_i2c_init.general_call = MD_I2C_GENERALCALL_DISABLE;
    s_i2c_init.module       = MD_I2C_MODULE_SLAVE;
    s_i2c_init.dual_addr    = MD_I2C_DUALADDR_ENABLE;
    s_i2c_init.no_stretch   = MD_I2C_NOSTRETCH_DISABLE;
    s_i2c_init.own_addr1    = SLAVE_ADDR << 1;
    md_i2c_init(COMMUNICATION_TYPE, &s_i2c_init);

    /* Config i2c1 interrupt */
    NVIC_SetPriority(I2C1_EV_IRQn, 0x01);
    NVIC_EnableIRQ(I2C1_EV_IRQn);
    NVIC_SetPriority(I2C1_ERR_IRQn, 0x01);
    NVIC_EnableIRQ(I2C1_ERR_IRQn);

    /* Init state machine */
    fsm_comm_func_init();
    fsm_exec_func_init();
    fsm_para_init();

#ifdef __USE_CRC32
    /* Determine whether the length is valid */
    len_hex = *((uint32_t *)CRC_CAL_ADDR + 1);
    if (len_hex <= CRC_CAL_ADDR - APP_ADDR)
    {
        /* If the verification is valid, jump to app */
        if (verify_valid() == PASS)
        {
            g_isp_data.p_go(GO_APP);
        }
    }
#else
    g_isp_data.p_go(GO_APP);
#endif

    while (1)
    {
        while (fsm_is_trigger())
        {
             proc_fsm();
        }
    }
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
