/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */

#include "ald_conf.h"

/* Exported Constants -------------------------------------------------------- */


/* Exported Functions -------------------------------------------------------- */


/* Exported Variables -------------------------------------------------------- */
extern uint8_t g_flag;
extern uint16_t g_rx_i;
extern can_handle_t g_can_handle;
extern can_rx_msg_t g_rx_msg;   /*CAN RX msg obj */
extern uint16_t g_frame_timer;

/* Exported Types ------------------------------------------------------------ */


/* Exported Macros ----------------------------------------------------------- */
#define MASKID      0x003

#define LED_PORT GPIOC
#define LED_PIN GPIO_PIN_12

#define APP_ADDR        0x0000
#define BOOT_ADDR       0x7E000
#define CRC_CAL_PAGE_ADDR    0x7BC00
#define GO_APP      0xFFFFFFFE
#define GO_BOOT     0xFFFFFFFD

#define POS_ACK 0x79
#define NEG_ACK 0x1F

#define FRAME_INTERVAL   500    /* the longest time interval between received cmd frame and execution result frame */

#endif  /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
