/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    biyq            the first version
 *          22 Feb  2023    shicc           version:1.0.1
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include "main.h"


/* Public Variables ---------------------------------------------------------- */
uint32_t  len_hex;

/* Public Function ---------------------------------------------------------- */


/* Private Macros ------------------------------------------------------------ */


/* Private Variables--------------------------------------------------------- */


/* Private Constants --------------------------------------------------------- */


/* Private function prototypes ----------------------------------------------- */


/* Private Function ---------------------------------------------------------- */
/**
  * @brief  init pins used fot can communication.
  * @param  None
  * @retval None
  */
void can_pins_init(void)
{
    gpio_init_t gpio_config;

    /* Initialize CAN_TX pin */  
    gpio_config.odos  = GPIO_PUSH_PULL;
    gpio_config.pupd  = GPIO_PUSH_UP;
    gpio_config.mode  = GPIO_MODE_OUTPUT; 
    gpio_config.nodrv = GPIO_OUT_DRIVE_6;
    gpio_config.podrv = GPIO_OUT_DRIVE_6;
    gpio_config.flt   = GPIO_FILTER_DISABLE; 
    gpio_config.type  = GPIO_TYPE_TTL;      
    gpio_config.func  = GPIO_FUNC_3;
    ald_gpio_init(GPIOB, GPIO_PIN_9, &gpio_config);

    /* Initialize CAN_RX pin */
    gpio_config.mode  = GPIO_MODE_INPUT;
    ald_gpio_init(GPIOB, GPIO_PIN_8, &gpio_config);

    return;
}


/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Config can */
    can_pins_init();
    can_init();

    /* Config can interrupt */
    ald_mcu_irq_config(CAN0_RX0_IRQn, 3, 3, ENABLE);

    /* Init state machine */
    fsm_comm_func_init();
    fsm_exec_func_init();
    fsm_para_init();

#ifdef __USE_CRC32
    /* Determine whether the length is valid */
    len_hex = *((uint32_t *)CRC_CAL_ADDR + 1);
    if (len_hex <= CRC_CAL_ADDR - APP_ADDR)
    {
        /* If the verification is valid, jump to app */
        if (verify_valid() == PASS)
        {
            g_isp_data.p_go(GO_APP);
        }
    }
#else
    g_isp_data.p_go(GO_APP);
#endif

    while (1)
    {
        while (fsm_is_trigger())
        {
            proc_fsm();
        }
    }
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
