/**********************************************************************************
 *
 * @file    boot_conf.h
 * @brief   boot config infomation file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          31 Jan 2024        shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef   __BOOT_CONF_H__
#define   __BOOT_CONF_H__

/* Includes ------------------------------------------------------------------ */
/* Exported Macros ----------------------------------------------------------- */

/*BOOT 程序区*/
#define BOOT_FLASH_S            (0x000000)
#define BOOT_FLASH_E            (0x007BFF)
#define APP_FLASH_S             (0x008000)
#define APP_FLASH_E             (0x043FFF)
#define UPDATE_FLASH_S          (0x044000)
#define UPDATE_FLASH_E          (0x07FFFF)

#define APP_FLASH_SIZE          (APP_FLASH_E-APP_FLASH_S+1)
/*更新标志 + 信息区域。区域大小 = 1页FLASH大小*/
#define INFO_FLAG_FLASH_S       (0x007C00)
#define INFO_FLAG_FLASH_E       (0x007FFF)

/*更新信息地址*/
#define UPDATE_INFO_CRC_LEN             (INFO_FLAG_FLASH_S)
#define UPDATE_INFO_CRC_VALUE           (INFO_FLAG_FLASH_S+4)

#define SECTION_ADDR(sec)   (FAT_AND_NEW_APP_FLASH_S + (DISK_BLOCK_SIZE * (sec)))

#define VALID_APP_ADDR(a) ((APP_FLASH_S>0&&(a) >= APP_FLASH_S) && (a) <= APP_FLASH_E)
/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */

#endif /*__BOOT_CONF_H__*/
