/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"
#include <stdio.h>
#include "xmodem_frame.h"
#include "spi_flash.h"
#include "stdio_uart.h"
/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

crc_handle_t g_h_crc;
/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

void enter_flash_shell(void);

typedef struct {
    GPIO_TypeDef*port;
    uint32_t pin;
}key_binding_t;

const key_binding_t key_pins[] =
{
    {KEY_CENTER_PORT,KEY_CENTER_PIN},
    {KEY_UP_PORT,KEY_UP_PIN },
    {KEY_DOWN_PORT,KEY_DOWN_PIN },
    {KEY_LEFT_PORT,KEY_LEFT_PIN },
    {KEY_RIGHT_PORT,KEY_RIGHT_PIN },
};

/*
 * @brief   Init gpio for keys and test out pin
 * @retval  None
 */
void init_gpio(void)
{
    gpio_init_t gpio_init;

    memset(&gpio_init, 0x0, sizeof(gpio_init)); /* initialize the gpio_init */
    gpio_init.mode = GPIO_MODE_OUTPUT;
    gpio_init.odos = GPIO_PUSH_PULL;
    gpio_init.pupd = GPIO_FLOATING;
    gpio_init.func = GPIO_FUNC_1;
    gpio_init.podrv = GPIO_OUT_DRIVE_6;
    gpio_init.nodrv = GPIO_OUT_DRIVE_6;

    memset(&gpio_init, 0x0, sizeof(gpio_init)); /* initialize the gpio_init */
    gpio_init.mode = GPIO_MODE_INPUT;
    gpio_init.pupd = GPIO_FLOATING;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_TTL;
    gpio_init.func = GPIO_FUNC_1;
    ald_gpio_init(KEY_CENTER_PORT, KEY_CENTER_PIN, &gpio_init);
    ald_gpio_init(KEY_UP_PORT, KEY_UP_PIN, &gpio_init);
    ald_gpio_init(KEY_DOWN_PORT, KEY_DOWN_PIN, &gpio_init);
    ald_gpio_init(KEY_LEFT_PORT, KEY_LEFT_PIN, &gpio_init);
    ald_gpio_init(KEY_RIGHT_PORT, KEY_RIGHT_PIN, &gpio_init);

    return;
}


/*
 * @brief   Test key state
 * @retval  0 -> 1 ==>  1 (release)
 *          1 -> 0 ==> -1 (press)
 *          others ==>  0
 */
int test_key(int key, int *state)
{
    int s = ald_gpio_read_pin(key_pins[key].port, key_pins[key].pin);
    int ret = s - *state;
    *state = s;
    return ret;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Initialize pin */
    init_gpio();
    init_uart_pin();
    init_uart();

    printf("hello\r\n");
    init_mcu_spi();
    enter_flash_shell();
    init_dac();
    init_pwm();
    init_adc();
    start_adc();
    
    /* Start DAC play loop (use internal flash for audio) */
    //start_dac_audio();
    
    /* Start main audio play/record loop (DAC/PWM output, ADC input) */
    start_audio();
    
    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
