/**********************************************************************************
 *
 * @file    adc_main.c
 * @brief   ADC init and loop
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include <string.h>
#include <stdio.h>

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
adc_handle_t g_adc_config;
adc_nch_conf_t g_nch_config;
uint32_t g_adc_result;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */


void normal_convert_complete(adc_handle_t *arg);
/**
  * @brief  Initializate pin of adc module.
  * @retval None.
  */
void init_adc_pin(void)
{
    /* Initialize ADC pin */
    gpio_init_t gpio_config;

    memset(&gpio_config, 0, sizeof(gpio_init_t));

    gpio_config.mode = GPIO_MODE_CLOSE;
    gpio_config.pupd = GPIO_FLOATING;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_0;
    ald_gpio_init(ADC_IN_PORT, ADC_IN0_PIN, &gpio_config);
    ald_gpio_init(ADC_IN_PORT, ADC_IN1_PIN, &gpio_config);
    ald_gpio_init(ADC_IN_PORT, ADC_IN2_PIN, &gpio_config);
    ald_gpio_init(ADC_IN_PORT, ADC_IN3_PIN, &gpio_config);

    return;
}

/**
  * @brief  Initializate ADC.
  * @retval None.
  */
void init_adc(void)
{
    init_adc_pin();
    
    memset(&g_adc_config, 0, sizeof(adc_handle_t));

    /* Initialize adc */
    g_adc_config.perh = ADC0;
    g_adc_config.init.align    = ADC_DATAALIGN_RIGHT;
    g_adc_config.init.scan     = ENABLE;
    g_adc_config.init.cont     = ENABLE;
    g_adc_config.init.disc     = ADC_ALL_DISABLE;
    g_adc_config.init.disc_nr  = ADC_DISC_NR_1;
    g_adc_config.init.data_bit = ADC_CONV_BIT_12;
    g_adc_config.init.div      = ADC_CKDIV_64;
    g_adc_config.init.nche_sel = ADC_NCHESEL_MODE_ALL;
    g_adc_config.init.nch_nr   = ADC_NCH_NR_1;
    g_adc_config.init.n_ref    = ADC_NEG_REF_VSS;
    g_adc_config.init.p_ref    = ADC_POS_REF_VDD;
    g_adc_config.normal_cplt_cbk = NULL;
    ald_adc_init(&g_adc_config);
    
    g_nch_config.ch   = ADC_CHANNEL_0;
    g_nch_config.idx  = ADC_NCH_IDX_1;
    g_nch_config.samp = ADC_SAMPLETIME_15;
    ald_adc_normal_channel_config(&g_adc_config, &g_nch_config);
}

/**
  * @brief  Adc normal convert complete.
  * @param  arg: Pointer to adc_handle_t structure.
  * @retval None.
  */
void normal_convert_complete(adc_handle_t *arg)
{
    g_adc_result = ald_adc_normal_get_value(&g_adc_config) * 3320 / 4096;
    return;
}

void start_adc()
{
    ald_adc_normal_start(&g_adc_config);
    /*while (1)
    {
        ald_gpio_write_pin(TEST_OUT_PORT,TEST_OUT_PIN,1);
        ald_adc_normal_start_by_it(&g_adc_config);
        ald_delay_ms(10);
    }*/
}
