/**********************************************************************************
 *
 * @file    shell_util.h
 * @brief   Header file for shell_util.c
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 #ifndef __SHELL_UTIL_H__
#define __SHELL_UTIL_H__

#include <stdint.h>

#ifndef MAX
    #define MAX(a,b) ((a)>(b)?(a):(b))
#endif
#ifndef MIN
    #define MIN(a,b) ((a)<(b)?(a):(b))
#endif

typedef char (*FuncShellGetCh)(void);

/* CMD register data (name nad func addr) */
struct CMD_FUNC
{
    const char *name;
    int (*func)(int argc, char **argv);
};

/* Shell data */
struct ShellEnv
{
    struct CMD_FUNC *cmd_table;
    char *buf;
    uint32_t buf_p;
    uint32_t buf_len;

    uint32_t flag;
};
enum{
    SHELL_EXIT=0x1,
};

/* Split an input by space */
int split_cmd(char *s, char **args, int len);

/* Get an unsigned int in dec/hex */
uint32_t get_uint(const char *s);

/* Input a char to shell */
void shell_input(char ch, struct ShellEnv *env);

/* Enter shell loop */
void enter_shell_loop(struct ShellEnv *env);

#endif
