/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"

/* Exported Types ------------------------------------------------------------ */
/* Exported Macros ----------------------------------------------------------- */
#if defined(ES_PDS_V2)
#define UART_TX_PORT GPIOE
#define UART_TX_PIN  GPIO_PIN_2
#define UART_RX_PORT GPIOE
#define UART_RX_PIN  GPIO_PIN_3
#define UARTX UART2
#define UARTX_IRQn UART2_IRQn
#else
#define UART_TX_PORT GPIOB
#define UART_TX_PIN  GPIO_PIN_10
#define UART_RX_PORT GPIOB
#define UART_RX_PIN  GPIO_PIN_11
#define UARTX UART0
#define UARTX_IRQn UART0_IRQn
#endif

#define DAC0_OUT_PORT	GPIOA
#define DAC0_OUT_PIN	GPIO_PIN_4

#define DAC1_OUT_PORT   GPIOA
#define DAC1_OUT_PIN    GPIO_PIN_5 

#define ADC_IN_PORT GPIOC
#define ADC_IN0_PIN GPIO_PIN_0
#define ADC_IN1_PIN GPIO_PIN_1
#define ADC_IN2_PIN GPIO_PIN_2
#define ADC_IN3_PIN GPIO_PIN_3

#define GP16C4T0_CHANNEL_PORT GPIOB
#define GP16C4T0_CHANNEL1_PIN GPIO_PIN_6
#define GP16C4T0_CHANNEL2_PIN GPIO_PIN_7
#define GP16C4T0_CHANNEL3_PIN GPIO_PIN_8
#define GP16C4T0_CHANNEL4_PIN GPIO_PIN_9


#if defined(ES_PDS_V2)
#define KEY_CENTER_PORT GPIOF
#define KEY_CENTER_PIN  GPIO_PIN_7 
#define KEY_UP_PORT     GPIOF
#define KEY_UP_PIN      GPIO_PIN_1 
#define KEY_DOWN_PORT   GPIOF
#define KEY_DOWN_PIN    GPIO_PIN_4
#define KEY_LEFT_PORT   GPIOF
#define KEY_LEFT_PIN    GPIO_PIN_6
#define KEY_RIGHT_PORT  GPIOF
#define KEY_RIGHT_PIN   GPIO_PIN_0
#else
#define KEY_CENTER_PORT GPIOC
#define KEY_CENTER_PIN  GPIO_PIN_10 
#define KEY_UP_PORT     GPIOB
#define KEY_UP_PIN      GPIO_PIN_2 
#define KEY_DOWN_PORT   GPIOB
#define KEY_DOWN_PIN    GPIO_PIN_12
#define KEY_LEFT_PORT   GPIOC
#define KEY_LEFT_PIN    GPIO_PIN_11
#define KEY_RIGHT_PORT  GPIOC
#define KEY_RIGHT_PIN   GPIO_PIN_12
#endif

#if defined(ES_PDS_V2)
#define SPI_NSS_PORT  GPIOB
#define SPI_NSS_PIN   GPIO_PIN_0
#define SPI_SCK_PORT  GPIOD
#define SPI_SCK_PIN   GPIO_PIN_3
#define SPI_MOSI_PORT GPIOB
#define SPI_MOSI_PIN  GPIO_PIN_5
#define SPI_MISO_PORT GPIOB
#define SPI_MISO_PIN  GPIO_PIN_4
#else
#define SPI_NSS_PORT  GPIOB
#define SPI_NSS_PIN   GPIO_PIN_0
#define SPI_SCK_PORT  GPIOB
#define SPI_SCK_PIN   GPIO_PIN_3
#define SPI_MOSI_PORT GPIOB
#define SPI_MOSI_PIN  GPIO_PIN_5
#define SPI_MISO_PORT GPIOB
#define SPI_MISO_PIN  GPIO_PIN_4
#endif

#define  USE_SPI_FLASH 1
#define  USE_INTERNAL_FLASH 0

/* Exported Variables -------------------------------------------------------- */
extern adc_handle_t g_adc_config;
extern dac_handle_t g_h_dac;
extern uart_handle_t g_uart_init;
extern void init_pwm(void);
extern void init_dac(void);
extern void init_adc(void);
extern void start_dac_audio(void);
extern void start_dac(void);
extern void start_pwm(void);
extern void start_adc(void);
extern int test_key(int key,int*state);

/* Set audio play/record sample rate */
extern void init_sample_timer(uint32_t sample_rate);

/* Enable or disable ADPCM decode for audio data in internal flash */
extern void set_adpcm(uint8_t enabled);
/* Start audio main loop (ADC/DAC/PWM) */
extern void start_audio(void);
/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

#endif    /*__MAIN_H__*/


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
