/**********************************************************************************
 *
 * @file    audio_read.h
 * @brief   read audio
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
#ifndef __FLASH_UTIL_H__
#define __FLASH_UTIL_H__

#include <stdint.h>
#include "spi_flash.h"

/* Flash file struct */
typedef struct FlashFile_t{
    int index;
    uint32_t data_addr;
    uint32_t data_size;
    
    uint32_t read_ptr;
    
    uint32_t flag;
}FlashFile;

/* Flash record in flash */
struct FlashRecord{
    uint32_t faddr;
    uint32_t fsize;
    char name[56];
};

/* Flash iterator in list */
typedef struct {
    struct FlashRecord file;
    int index;
}FlashFileIter;

/* list file in spi flash */
int flash_file_list(FlashFileIter*f);

/* Find the index of 'name' */
int flash_file_find(const char*name);

/* Open file of index */
int flash_file_open(int index,FlashFile*file);

/* Read file */
int flash_file_read(FlashFile*file,void*buf,uint32_t len);

/* Find a free index */
int flash_find_free_index(uint32_t *data_addr);

/* Create a new file in flash */
int flash_file_new(FlashFile*file,const char*name,uint32_t len);

/* Close a file and write file size 
 * (only necessary when create a new file with len==0) */
int flash_file_close(FlashFile*file);

/* Write to file */
int flash_file_write(FlashFile*file,void*buf,uint32_t len);

/* Prepare for fast write (erase some sectors before write) */
int flash_file_prepare_write(FlashFile*file,uint32_t len);

/* Fast write to file (no previously erase) */
int flash_file_fast_write(FlashFile*file,void*buf,uint32_t len);

/* Delete a file (clear index data) */
int flash_file_delete(FlashFile*file);

#define OFFSETOF(x,T) ((uint32_t)(&(((T*)0)->x)))
#endif
