/**********************************************************************************
 *
 * @file    audio_read.h
 * @brief   read audio
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 #ifndef __AUDIO_READ_H__
#define __AUDIO_READ_H__

#include <stdint.h>

typedef struct
{
    uint32_t   ChunkID;       /* 0 */
    uint32_t   FileSize;      /* 4 */
    uint32_t   FileFormat;    /* 8 */

    uint32_t   SubChunk1ID;   /* 12 */
    uint32_t   SubChunk1Size; /* 16*/
    uint16_t   AudioFormat;   /* 20 */
    uint16_t   NbrChannels;   /* 22 */
    uint32_t   SampleRate;    /* 24 */

    uint32_t   ByteRate;      /* 28 */
    uint16_t   BlockAlign;    /* 32 */
    uint16_t   BitPerSample;  /* 34 */
    uint32_t   SubChunk2ID;   /* 36 */
    uint32_t   SubChunk2Size; /* 40 */

} wave_formattypedef_t;
#define WAVF_RIFF 0x46464952
#define WAVF_WAVE 0x45564157
#define WAVF_fmt  0x20746D66
#define WAVF_data 0x61746164

/* Prepare audio data (from internal ROM) */
void prepare_audio(int16_t *buf);

/* Set playing sound to 'name' */
int setup_flash_wav(const char*name);

/* Read audio data (from SPI flash) */
void read_audio_data(int16_t *buf);

/* Sample buffer */
extern int16_t sample_buffer[1024 * 2];

/* Sample data in internal flash */
extern const unsigned char g_sample_wav_data[];

/* Sample data length in internal flash */
extern const unsigned int g_sample_wav_data_len;

#endif
