#ifndef __RD_BUF_H__
#define __RD_BUF_H__
#include <string.h>
#include <stdint.h>

struct RD_buffer
{
    uint8_t *buffer;
    uint32_t buffer_size;
    uint32_t block_size;
    uint32_t blocks;
    int ibegin, iend;
    int num;
};

uint8_t *rd_get(struct RD_buffer *buf);
int rd_pop(struct RD_buffer *buf);
int rd_put(struct RD_buffer *buf, uint8_t *data);
uint8_t *rd_new(struct RD_buffer *buf);
int rd_reset(struct RD_buffer *buf);
struct RD_buffer *rd_static_init(void *data, uint32_t total_size, uint32_t blocks);
#endif
