/**********************************************************************************
 *
 * @file    spi_flash.h
 * @brief   Header file for DEMO
 *
 * @date    07 Dec 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          07 Dec 2021     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__

/* Includes ------------------------------------------------------------------ */

#include "utils.h"
#include "ald_conf.h"

/* Exported Types ------------------------------------------------------------ */
/**
  * @brief The Types of command
  */
typedef enum
{
    SD_SUCCESSED   = 0x00,  /*< Success */
    SD_CMD0_ERROR  = 0x01,  /*< CMD0 error */
    SD_CMD1_ERROR  = 0x02,  /*< CMD1 error */
    SD_CMD8_ERROR  = 0x08,  /*< CMD8 error */
    SD_WRITE_ERROR = 0x03,  /*< Write error */
    SD_READ_ERROR  = 0x04,  /*< Read error */
    SD_CMD9_ERROR  = 0x09,  /*< CMD9 error */
    SD_CMD41_ERROR = 0x41,  /*< CMD41 error */
    SD_CMD55_ERROR = 0x55,  /*< CMD55 error */
} sd_card_state_t;

typedef enum
{
    SD_CMD0   = 0,  /*< CMD0 */
    SD_CMD1   = 1,  /*< CMD1 */
    SD_CMD8   = 8,  /*< CMD8 */
    SD_CMD9   = 9,  /*< CMD9 */
    SD_CMD10  = 10, /*< CMD10 */
    SD_CMD12  = 12, /*< CMD12 */
    SD_CMD17  = 17, /*< CMD17 */
    SD_CMD18  = 18, /*< CMD18 */
    SD_CMD24  = 24, /*< CMD24 */
    SD_CMD25  = 25, /*< CMD25 */
    SD_CMD32  = 32, /*< CMD32 */
    SD_CMD33  = 33, /*< CMD33 */
    SD_CMD38  = 38, /*< CMD38 */
    SD_CMD55  = 55, /*< CMD55 */
    SD_CMD58  = 58, /*< CMD58 */
    SD_ACMD41 = 41, /*< CMD41 */
} sd_card_cmd_t;


/* Exported Macros ----------------------------------------------------------- */
#define SD_PORT         GPIOC
#define SD_CS_PIN       GPIO_PIN_0
#define SD_SCL_PIN      GPIO_PIN_1
#define SD_MISO_PIN     GPIO_PIN_2
#define SD_MOSI_PIN     GPIO_PIN_3
/* device info */
#define SEC_SIZE        512         /* byte */
#define BLK_SIZE        1           /* 1 sectors */
#define DEV_SIZE        0x1DACC00   /* in unit of sector */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
ald_status_t ll_micro_sd_init(void);
ald_status_t ll_micro_sd_sector_erase(uint32_t start_sec, uint32_t end_sec);
ald_status_t ll_micro_sd_sector_read(uint8_t *str_buf, uint32_t sec, uint32_t sec_num);
ald_status_t ll_micro_sd_sector_write(const uint8_t *src_buf, uint32_t sec, uint32_t sec_num);

#endif    /*__FLASH_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
