/**********************************************************************************
 *
 * @file    * @brief *
 * @brief   *
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __gpio_H
#define __gpio_H
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Includes ---------------------------------------------------------------- */

#include "main.h"

/* Exported Types ---------------------------------------------------------- */

/* Exported Macros ----------------------------------------------------------- */

/* IIC Code */
#define SDA_IN()  {GPIOB->MODE &= ~(3UL << 18); GPIOB->MODE |= (1UL << 18);}    /*Pull on the input*/
#define SDA_OUT() {GPIOB->MODE |= (3UL << 18);} /*Reuse push-pull output at a high speed*/
/*IO operations function*/
#define WRITE_SCL_H()   (GPIOB->BSRR = 1<<8) /*Write SCL*/
#define WRITE_SCL_L()   (GPIOB->BSRR = 1<<(8+16))
#define WRITE_SDA_H()   (GPIOB->BSRR = 1<<9) /*Write the SDA*/
#define WRITE_SDA_L()   (GPIOB->BSRR = 1<<(9+16)) /*Write the SDA*/

#define READ_SDA  (GPIOB->DIN & 1<<9)>>9  /*Read the SDA*/

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */

void MX_GPIO_Init(void);
void IIC_Init(void);                                    /*Initialize the IIC IO port*/
void IIC_Start(void);                                                   /*Send the IIC start signal*/
void IIC_Stop(void);                                                /*Send the IIC stop signal*/
void IIC_Send_Byte(uint8_t txd);                            /*IIC sends a byte*/
uint8_t IIC_Read_Byte(unsigned char ack);           /*IIC read a byte*/
uint8_t IIC_Wait_Ack(void);                                     /*IIC wait for an ACK signal*/
void IIC_Ack(void);                                                     /*IIC an ACK signal*/
void IIC_NAck(void);                                                    /*IIC is not an ACK signal*/
uint8_t IIC_Write_One_Byte(uint8_t DevAddr, uint8_t RegAddr, uint8_t Data);
uint8_t IIC_Read_One_Byte(uint8_t DevAddr, uint8_t RegAddr);
void delay_us(uint16_t us);

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /*__ pinoutConfig_H */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
