/**
  *********************************************************************************
  *
  * @file    bsp_uart.h
  * @brief   UART for debug printf
  *
  * @version V1.0
  * @date    12 Aug 2021
  * @author  shiwa
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Aug 2021     shiwa           The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __BSP_UART_H__
#define   __BSP_UART_H__
/* Includes ---------------------------------------------------------------- */
#include "ald_conf.h"
#include <stdio.h>

/* Exported Types ---------------------------------------------------------- */

/* Exported Macros ----------------------------------------------------------- */

/* UART0 config & pins */
#define M_UART UART2
#define M_UART_BAUD 115200
#define M_UART_TX_PORT GPIOE
#define M_UART_TX_PIN GPIO_PIN_2
#define M_UART_TX_FUNC GPIO_FUNC_3
#define M_UART_RX_PORT GPIOE
#define M_UART_RX_PIN GPIO_PIN_3
#define M_UART_RX_FUNC GPIO_FUNC_3
#define M_UART_IRQ UART2_IRQn
#define M_UART_HANDLER UART2_Handler

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */

/**
  * @brief  Init UART0 for printf/scanf
  * @retval None
  */
extern void init_uart(void);
/**
  * @brief  UART receive by interrupt
  */
extern void bsp_uart_recv(uint8_t *data, uint16_t len, uint16_t timeout);
/**
  * @brief  Check if received data
  */
uint32_t bsp_uart_recved(char *buf, int length);
#endif /* _BSP_UART_H_ */
