/**********************************************************************************
 *
 * @file    gen_dev.h
 * @brief   Header file for gen_dev.c module.
 * @date    12 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          12 Nov 2021     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FF_GEN_DRV_H__
#define   __FF_GEN_DRV_H__

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/* Includes ------------------------------------------------------------------ */
#include "diskio.h"
#include "ff.h"
#include "stdint.h"

/* Exported Macros ----------------------------------------------------------- */


/* Exported Constants -------------------------------------------------------- */

/* Exported Types ---------------------------------------------------------- */
/**
  * @brief  General physcial drive operations structure definition.
  */
typedef struct
{
    DSTATUS(*pdrv_init)(void);                              /* Initialize physical drive */
    DSTATUS(*pdrv_stat)(BYTE, void *);                      /* Not used */
    DRESULT(*pdrv_read)(BYTE *, DWORD, UINT);               /* Read Sector(s) from physical drive */
#if FF_FS_READONLY == 0
    DRESULT(*pdrv_write)(const BYTE *, DWORD, UINT);        /* Write data to physical drive */
#endif /* FF_FS_READONLY == 0*/
    DRESULT(*pdrv_ioctl)(BYTE, void *);
} gen_pdrv_io_t;

/**
  * @brief  General logical drive structure definition.
  */
typedef struct
{
    uint8_t             pdrv_num;                   /* Store the physical drive number which logical drive partitioned in */
    uint8_t             lun;                        /* Used for USB */
} gen_ldrv_t;

/**
  * @brief  General physcial drive structure definition.
  */
typedef struct
{
    DSTATUS                 is_init;                        /* Indicate whether current physical driver is initialized */
    uint8_t                 vol_num;                        /* store the logical drive number in current physical drive */
    gen_pdrv_io_t           *drv_io;                        /* physical drive opereations */
} gen_pdrv_t;

/* Exported Variables -------------------------------------------------------- */
extern gen_pdrv_t pdrv_info[FF_VOLUMES];

#if FF_MULTI_PARTITION
/* Imported Variables -------------------------------------------------------- */
extern PARTITION VolToPart[FF_VOLUMES];
#endif

/* Exported Functions ------------------------------------------------------ */
DSTATUS ff_drv_register(const uint8_t pdrv_num, const gen_pdrv_io_t *pdrv, uint8_t *ldrv_path, uint8_t ldpath_len, uint8_t lun);
DSTATUS ff_drv_unregister(const uint8_t pdrv_num, uint8_t *ldrv_path, uint8_t ldpath_len, uint8_t lun);
void    ff_drv_info(uint8_t *pdnum, uint8_t *ldnum);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* __FF_GEN_DRV_H__ */


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
