/*
 * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Change Logs:
 * Date           Author        Notes
 * 2022-11-29     shiwa         the first version
 */
#include "hpf.h"

//*********** Structure Init Function ****//
void HPF_1orderRC_F_init(HPF_1orderRC_F *v)
{
    v->Vi_prev = 0.0f;
    v->Vo_prev = 0.0f;  

    //high pass filter @cutoff frequency = 0.05 Hz
    v->Fcutoff = 0.05f;

    v->Fs = 8000;  
    
    v->RC = 1.0f / 2.0f / 3.1415926f / v->Fcutoff;
    v->Coff = v->RC / (v->RC + 1.0f / v->Fs);
    
    v->Vi_prev_i = 0;
    v->Vo_prev_i = 0;
    v->Coff_i = (int)(v->Coff*65536);
    
}

//*********** Function Definition ********//
float HPF_1orderRC_F_FUNC(HPF_1orderRC_F *v,float Vi)
{
    float Vo = (Vi - v->Vi_prev + v->Vo_prev) * v->Coff;

    //update
    v->Vo_prev = Vo;
    v->Vi_prev = Vi;

    return Vo;
}
//*********** Function Definition ********//
int16_t HPF_1orderRC_F_FUNC_i(HPF_1orderRC_F *v,int16_t Vi)
{
    int16_t Vo = (Vi - v->Vi_prev_i + v->Vo_prev_i) * v->Coff_i/65536;

    //update
    v->Vo_prev_i = Vo;
    v->Vi_prev_i = Vi;

    return Vo;
}
