/**********************************************************************************
 *
 * @file    stdio_uart.h
 * @brief   Header file for stdio_uart.c
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 #ifndef __STDIO_UART_H__
#define __STDIO_UART_H__
#include "ald_conf.h"

/* Global uart handler */
extern uart_handle_t g_uart_init;

/* Init uart */
extern void init_uart(void);

/* Init pins of uart */
extern void init_uart_pin(void);

/* Send a string */
extern int uart_send_str(const char *s, uint32_t len, uint32_t timeout);

/* Receive a string */
extern int uart_recv_str(char *s, uint32_t len, uint32_t timeout);

/* Get if received any (only use when rx_irq enabled) */
extern int uart_peak_ch(void);

/* Enable/Disable UART Receive irq */
extern int uart_enable_rx_irq(int enable);

/* Reset RX fifo */
static inline void uart_reset_rx_fifo(void)
{
    UART_FIFO_RX_RESET(&g_uart_init);
}
#endif
