/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    20 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Mar 2023     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"

/* Exported Types ------------------------------------------------------------ */
/* Exported Macros ----------------------------------------------------------- */
#if 0
#define UART_TX_PORT GPIOE
#define UART_TX_PIN  GPIO_PIN_2
#define UART_RX_PORT GPIOE
#define UART_RX_PIN  GPIO_PIN_3
#define UARTX UART2
#else
#define UART_TX_PORT GPIOB
#define UART_TX_PIN  GPIO_PIN_10
#define UART_RX_PORT GPIOB
#define UART_RX_PIN  GPIO_PIN_11
#define UARTX UART0
#endif
#define DAC0_OUT_PORT	GPIOA
#define DAC0_OUT_PIN	GPIO_PIN_4

#define KEY_PORT        GPIOF
#define KEY_CENTER_PIN  GPIO_PIN_7 
#define KEY_UP_PIN      GPIO_PIN_1 
#define KEY_DOWN_PIN    GPIO_PIN_4
#define KEY_LEFT_PIN    GPIO_PIN_6
#define KEY_RIGHT_PIN   GPIO_PIN_0
/* Exported Variables -------------------------------------------------------- */
extern adc_handle_t g_adc_config;
extern dac_handle_t g_h_dac;
extern uart_handle_t g_uart_init;
extern void init_pwm(void);
extern void init_dac(void);
extern void init_adc(void);
extern void start_dac_audio(void);
extern void start_dac(void);
extern void start_pwm(void);
extern void start_adc(void);
extern void start_audio(void);
extern int test_key(int key,int*state);

extern const uint32_t g_sample_wav_data_len;
extern const uint8_t g_sample_wav_data[];
extern const uint32_t g_sample2_wav_data_len;
extern const uint8_t g_sample2_wav_data[];
/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

#endif    /*__MAIN_H__*/


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
