/**********************************************************************************
 *
 * @file    main.c
 * @brief   iwdt C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/* Private function prototypes ----------------------------------------------- */
static void uart_init(void);
static void uart_gpio_init(void);

/* Private Function ---------------------------------------------------------- */


/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);

    /* Enable LRC */
    SYSCFG_UNLOCK();
    md_cmu_enable_lrc();
    SYSCFG_LOCK();

    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    uart_init();
    printf("IWDT demo\r\n");

    /* Initialize IWDT */
    /* 注意：当IWDT是通过配置字使能时，md_iwdt_init对IWDT_CON寄存器配置无效，
             此时用户需要通过函数md_iwdt_set_count_overload自行配置IWDT_LOAD装载寄存器的值，
             配置IWDT_LOAD前需要对IWDT解锁，配置完成后要对IWDT上锁。*/
    md_iwdt_init(32000, DISABLE);

    /* Start WWDT */
    IWDT_UNLOCK();
    md_iwdt_enable();
    IWDT_LOCK();

    while (1)
    {
        /* Feed dog */
        IWDT_UNLOCK();
        md_iwdt_clear_flag_interrupt();
        IWDT_LOCK();
        printf("Feed dog\r\n");

        md_delay_1ms(1000);
    }
}

void uart_gpio_init(void)
{
    md_gpio_init_t g_gpio_init_s;

    md_gpio_init_struct(&g_gpio_init_s);

    g_gpio_init_s.mode = MD_GPIO_MODE_OUTPUT;
    g_gpio_init_s.func = MD_GPIO_FUNC_3;

    md_gpio_init(UART_PORT, UART_TX_PIN, &g_gpio_init_s);

    g_gpio_init_s.mode = MD_GPIO_MODE_INPUT;
    md_gpio_init(UART_PORT, UART_RX_PIN, &g_gpio_init_s);
}

void uart_init(void)
{
    md_uart_init_t g_uart_init_s;

    md_cmu_enable_perh_uart0();

    uart_gpio_init();

    md_uart_init_struct(&g_uart_init_s);

    md_uart_init(UART0, &g_uart_init_s);
}

#ifdef __GNUC__     /* GCC Compiler */
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt; 
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        if (*ptr_char == '\n')
        {
            cnt = 4000;
            while (!md_uart_is_active_flag_tfempty(UART0) && (--cnt));

            md_uart_set_send_data8(UART0, '\r');
        }

        cnt = 4000;
        while (!md_uart_is_active_flag_tfempty(UART0) && (--cnt));

        md_uart_set_send_data8(UART0, *ptr_char++);
    }

    return len;
}

void *_sbrk(intptr_t increment)
{
    extern char end asm("end");
    /* Defined by the linker. */
    static char *heap_end;
    char* prev_heap_end;
    heap_end += increment;

    return (void *)prev_heap_end;
}

void _read()
{

}

void _lseek()
{

}

void _close()
{

}

void _fstat()
{

}

void _isatty()
{

}

void _getpid()
{

}

void _kill()
{

}

void _exit()
{

}

#else
int fputc(int c, FILE *f)
{
    uint16_t cnt = 4000U;

    while (!md_uart_is_active_flag_tfempty(UART0) && (--cnt))
    {

    }

    md_uart_set_send_data8(UART0, c);

    return c;
}

#endif /* __GNUC__ */

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
