/**********************************************************************************
 *
 * @file    main.c
 * @brief   WDT DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
void uart_init(void);

/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_WDT
  * @{
  */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Enable wwdg and iwdg interrupt */
    ald_mcu_irq_config(WWDG_IRQn, 0, 1, ENABLE);

    uart_init();
    printf("MCU reset\r\n");
    printf("WWDT demo\r\n");

    /* Initialize WWDT */
    ald_wwdt_init(64000, WWDT_WIN_25, ENABLE);

    /* Start WWDT */
    ald_wwdt_start();

    while (1);
}

void uart_gpio_init(void)
{
    gpio_init_t g_gpio_init_s;

    memset(&g_gpio_init_s, 0, sizeof(g_gpio_init_s));

    g_gpio_init_s.mode = GPIO_MODE_OUTPUT;
    g_gpio_init_s.func = GPIO_FUNC_3;
    ald_gpio_init(UART_PORT, UART_TX_PIN, &g_gpio_init_s);

    g_gpio_init_s.mode = GPIO_MODE_INPUT;
    ald_gpio_init(UART_PORT, UART_RX_PIN, &g_gpio_init_s);
}

uart_handle_t g_h_uart = {0};
void uart_init(void)
{
    uart_gpio_init();

    g_h_uart.perh             = UART0;
    g_h_uart.init.baud        = 115200;
    g_h_uart.init.word_length = UART_WORD_LENGTH_8B;
    g_h_uart.init.stop_bits   = UART_STOP_BITS_1;
    g_h_uart.init.parity      = UART_PARITY_NONE;
    g_h_uart.init.mode        = UART_MODE_UART;
    g_h_uart.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&g_h_uart);
}

#ifdef __GNUC__     /* GCC Compiler */
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt;
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        if (*ptr_char == '\n')
        {
            cnt = 4000;

            while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

            g_h_uart.perh->TXBUF = '\r';
        }

        cnt = 4000;

        while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

        g_h_uart.perh->TXBUF = *ptr_char++;
    }

    return len;
}

void *_sbrk(intptr_t increment)
{
    extern char end asm("end");
    /* Defined by the linker. */
    static char *heap_end;
    char *prev_heap_end;

    heap_end += increment;

    return (void *)prev_heap_end;
}

void _read()
{

}

void _lseek()
{

}

void _close()
{

}

void _fstat()
{

}

void _isatty()
{

}

void _getpid()
{

}

void _kill()
{

}

void _exit()
{

}

#else
int fputc(int c, FILE *f)
{
    uint16_t cnt = 4000U;

    while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt))
    {

    }

    g_h_uart.perh->TXBUF = c;

    return c;
}

#endif /* __GNUC__ */
/**
  * @}
  */
/**
  * @}
  */


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
