/**********************************************************************************
 *
 * @file    nand.h
 * @brief   Header file for nand.c
 *
 * @date    12 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          12 Nov 2021     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __SRAM_DISKIO_H__
#define __SRAM_DISKIO_H__

/* Includes ------------------------------------------------------------------*/
#include "ff_gen_drv.h"
#include "spi_flash.h"

/* Exported Macros ----------------------------------------------------------- */

/* Exported Variables -------------------------------------------------------- */
extern const Diskio_drvTypeDef spi_flash_drv;

/* Exported Constants -------------------------------------------------------- */

/* Exported Types ---------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */
extern DRESULT spi_flash_read(BYTE lun, BYTE *buff, DWORD sector, UINT count);
extern DRESULT spi_flash_write(BYTE lun, const BYTE *buff, DWORD sector, UINT count);
extern DSTATUS spi_flash_init(BYTE lun);

#endif /* __SRAM_DISKIO_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
