/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate pin of usart module.
  * @retval None
  */
static void init_usart_pin(void)
{
    md_gpio_init_t gpio_config;
    md_gpio_init_struct(&gpio_config);

    /* Initialize tx pin */
    gpio_config.mode = MD_GPIO_MODE_OUTPUT;
    gpio_config.odos = MD_GPIO_OPEN_DRAIN;
    gpio_config.pupd = MD_GPIO_PUSH_UP;
    gpio_config.podrv = MD_GPIO_OUT_DRIVE_6;
    gpio_config.nodrv = MD_GPIO_OUT_DRIVE_6;
    gpio_config.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_config.type = MD_GPIO_TYPE_CMOS;
    gpio_config.func = MD_GPIO_FUNC_3;
    md_gpio_init(USART0_TX_PORT, USART0_TX_PIN, &gpio_config);

    return;
}

/**
  * @brief:  Initialize the usart.
  * @param:  None
  * @retval: None
  */
static void init_usart(void)
{
    md_usart_init_t usart_config;
    md_usart_init_struct(&usart_config);
    /* Initialize USART0 */
    usart_config.baud        = 9600;
    usart_config.word_length = MD_USART_WORD_LENGTH_9B;
    usart_config.stop_bits   = MD_USART_STOP_BITS_1;
    usart_config.parity      = MD_USART_PARITY_EVEN;
    usart_config.fctl        = MD_USART_HW_FLOW_CTL_NONE;
    usart_config.mode        = MD_USART_MODE_TX_RX;
    md_usart_init(USART0, &usart_config);

    md_usart_enable_half_duplex(USART0); 
    md_usart_enable_it_rxne(USART0);
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{
    /*Configure the system clock*/
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC_6, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);

    /*Initialize the SysTick interrupt*/
    md_init_1ms_tick();

    /*I2C clock can make*/
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    md_mcu_irq_config(USART0_IRQn, 0, ENABLE);

    /* Init USART */
    init_usart_pin();
    init_usart();

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
