/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

usart_handle_t g_usart_handle;

uint8_t g_tx_buf[512];
uint8_t g_rx_buf[10];
uint16_t g_tx_i = 0U;
uint8_t g_rx_i = 0U;

uint32_t g_data_addr;
uint8_t g_data_len;

uint8_t g_frame_flag = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of usart module.
  * @retval None
  */
void init_usart_pin(void)
{
    gpio_init_t gpio_config;
    memset(&gpio_config, 0x0, sizeof(gpio_init_t));
    /* Initialize tx pin */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(USART0_TX_PORT, USART0_TX_PIN, &gpio_config);

    /* Initialize rx pin */
    gpio_config.mode = GPIO_MODE_INPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(USART0_RX_PORT, USART0_RX_PIN, &gpio_config);

    return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_send_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_recv_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Send and receive a message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_send_recv_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_error(usart_handle_t *arg)
{
    return;
}

uint8_t ask_data_handle(void)
{
    if (g_rx_buf[0] != STA1 || g_rx_buf[1] != STA2 || g_rx_buf[2] != FRAME_LEN || g_rx_buf[8] != END1 || g_rx_buf[9] != END2)
    {
        return 0;
    }

    g_data_addr = (g_rx_buf[3] << 24) | (g_rx_buf[4] << 16) | (g_rx_buf[5] << 8) | (g_rx_buf[6]);
    g_data_len = g_rx_buf[7];

    return 1;
}

void answer_data_send(void)
{
    uint16_t i;
    uint8_t data_buf[512];

    memcpy(data_buf, (void *)g_data_addr, g_data_len); 
    g_tx_buf[0] = STA1;
    g_tx_buf[1] = STA2;
    g_tx_buf[2] = FRAME_LEN + g_data_len;
    g_tx_buf[3] = g_rx_buf[3];
    g_tx_buf[4] = g_rx_buf[4];
    g_tx_buf[5] = g_rx_buf[5];
    g_tx_buf[6] = g_rx_buf[6];
    g_tx_buf[7] = g_data_len;

    for (i = 0; i < g_data_len; i++)
    {
        g_tx_buf[8 + i] = data_buf[i];
    }

    g_tx_buf[8 + g_data_len] = END1;
    g_tx_buf[9 + g_data_len] = END2;

    USART0->DATA = g_tx_buf[0];
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Enable usart interrupt */
    ald_mcu_irq_config(USART0_IRQn, 3, ENABLE);

    /* Initialize pin */
    init_usart_pin();

    memset(&g_usart_handle, 0x0, sizeof(usart_handle_t));
    /* Initialize USART */
    g_usart_handle.perh               = USART0;
    g_usart_handle.init.baud          = 9600;
    g_usart_handle.init.word_length   = USART_WORD_LENGTH_9B;
    g_usart_handle.init.stop_bits     = USART_STOP_BITS_1;
    g_usart_handle.init.parity        = USART_PARITY_EVEN;
    g_usart_handle.init.mode          = USART_MODE_TX_RX;
    g_usart_handle.init.fctl          = USART_HW_FLOW_CTL_NONE;
    ald_usart_init(&g_usart_handle);

    WRITE_REG(USART0->STAT, ~(USART_STAT_TXCIF_MSK));
    SET_BIT(USART0->CON0, USART_CON0_TXCIE_MSK);
    SET_BIT(USART0->CON0, USART_CON0_RXNEIE_MSK);

    while (1)
    {
        if (g_frame_flag == 1)
        {
            if (ask_data_handle() == 1)
            {
                answer_data_send();
            }

            g_frame_flag = 0;
            memset(g_rx_buf, 0, 10);

            g_tx_i = 0;
        }
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
