/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

usart_handle_t g_usart_handle;
uint8_t        g_rx_buf[10];

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of usart module.
  * @retval None
  */
void init_usart_pin(void)
{
    gpio_init_t gpio_config;
    memset(&gpio_config, 0x00, sizeof(gpio_init_t));

    /* Initialize tx pin */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(USART0_TX_PORT, USART0_TX_PIN, &gpio_config);

    /* Initialize rx pin */
    gpio_config.mode = GPIO_MODE_INPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(USART0_RX_PORT, USART0_RX_PIN, &gpio_config);

    return;
}
/**
  * @brief  Send message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */

void usart_dma_send_complete(usart_handle_t *arg)
{
    ald_usart_recv_by_dma(&g_usart_handle, g_rx_buf, sizeof(g_rx_buf), 0);
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */

void usart_dma_recv_complete(usart_handle_t *arg)
{
    ald_usart_send_by_dma(&g_usart_handle, g_rx_buf, sizeof(g_rx_buf), 1);
    return;
}

/**
  * @brief  Send and receive a message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_send_recv_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_error(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    NVIC_SetPriority(USART0_IRQn, 2);
    NVIC_EnableIRQ(USART0_IRQn);

    /* Initialize pin */
    init_usart_pin();

    memset(&g_usart_handle, 0x00, sizeof(g_usart_handle));
    /* Initialize USART */
    g_usart_handle.perh               = USART0;
    g_usart_handle.init.baud          = 9600;
    g_usart_handle.init.word_length   = USART_WORD_LENGTH_8B;
    g_usart_handle.init.stop_bits     = USART_STOP_BITS_1;
    g_usart_handle.init.parity        = USART_PARITY_NONE;
    g_usart_handle.init.mode          = USART_MODE_TX_RX;
    g_usart_handle.init.fctl          = USART_HW_FLOW_CTL_NONE;
    g_usart_handle.rx_cplt_cbk        = usart_dma_recv_complete;
    g_usart_handle.tx_cplt_cbk        = usart_dma_send_complete;
    ald_usart_init(&g_usart_handle);

    /* Receive a message */
    ald_usart_recv_by_dma(&g_usart_handle, g_rx_buf, sizeof(g_rx_buf), 0);

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
