/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


/* Includes ------------------------------------------------------------------ */

#include "main.h"
#include "smart_card.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

usart_handle_t g_usart_handle;

uint8_t g_tx_buf[32];

uint8_t g_rx_buf[32];

uint8_t g_SMART_CARD_OK = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of usart module.
  * @retval None
  */
void init_usart_pin(void)
{
    gpio_init_t gpio_config;
    memset(&gpio_config, 0x00, sizeof(gpio_init_t));

    /* Initialize io pin */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_OPEN_DRAIN;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(CARD_IO_PORT, CARD_IO_PIN, &gpio_config);

    /* Initialize clk pin */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(CARD_CLK_PORT, CARD_CLK_PIN, &gpio_config);

    /* Initialize rst pin */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_1;
    ald_gpio_init(CARD_RST_PORT, CARD_RST_PIN, &gpio_config);

    return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_send_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_recv_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Send and receive a message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_send_recv_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_error(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Initialize pin */
    init_usart_pin();

    memset(&g_usart_handle, 0x00, sizeof(usart_handle_t));
    /* Initialize USART */
    g_usart_handle.perh               = USART0;
    g_usart_handle.init.baud          = 16129;
    g_usart_handle.init.word_length   = USART_WORD_LENGTH_9B;
    g_usart_handle.init.stop_bits     = USART_STOP_BITS_1_5;
    g_usart_handle.init.parity        = USART_PARITY_EVEN;
    g_usart_handle.init.mode          = USART_MODE_TX_RX;
    g_usart_handle.init.fctl          = USART_HW_FLOW_CTL_NONE;
    ald_usart_init(&g_usart_handle);

    SET_BIT(g_usart_handle.perh->CON2, USART_CON2_SMARTEN_MSK);
    SET_BIT(g_usart_handle.perh->CON1, USART_CON1_SCKEN_MSK);
    SET_BIT(g_usart_handle.perh->CON2, USART_CON2_NACK_MSK);
    MODIFY_REG(g_usart_handle.perh->GP, USART_GP_PSC_MSK, 2);
    MODIFY_REG(g_usart_handle.perh->GP, USART_GP_GTVAL_MSK, 2 << USART_GP_GTVAL_POSS);
    WRITE_REG(g_usart_handle.perh->STAT, ~(USART_STAT_TXCIF_MSK));

    while (reset_rec(g_rx_buf) == CARD_ERROR);

    while (instruction_test() == CARD_ERROR);

    g_SMART_CARD_OK = 1;

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
