/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


/* Includes ------------------------------------------------------------------ */

#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

usart_handle_t g_usart0_handle, g_usart1_handle;

char g_tx0_buf[256] = "USART0 : ";
uint32_t g_tx0_len;
uint32_t g_tx0_i = 0U;

char g_tx1_buf[256] = "USART1 : ";
uint32_t g_tx1_len;
uint32_t g_tx1_i = 0U;

uint8_t g_rx0_buf[256];
uint32_t g_rx0_len = sizeof(g_rx0_buf);
uint32_t g_rx0_i = 0U;

uint8_t g_rx1_buf[256];
uint32_t g_rx1_len = sizeof(g_rx1_buf);
uint32_t g_rx1_i = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of usart module.
  * @retval None
  */
void init_usart_pin(void)
{
    gpio_init_t gpio_config;
    memset(&gpio_config, 0x00, sizeof(gpio_init_t));
    /* Initialize usart0_tx pin */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_OPEN_DRAIN;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(USART0_TX_PORT, USART0_TX_PIN, &gpio_config);

    /* Initialize usart0_rx pin */
    gpio_config.mode = GPIO_MODE_INPUT;
    gpio_config.odos = GPIO_OPEN_DRAIN;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(USART0_RX_PORT, USART0_RX_PIN, &gpio_config);

    /* Initialize usart1_tx pin */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_OPEN_DRAIN;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_4;
    ald_gpio_init(USART1_TX_PORT, USART1_TX_PIN, &gpio_config);

    /* Initialize usart1_rx pin */
    gpio_config.mode = GPIO_MODE_INPUT;
    gpio_config.odos = GPIO_OPEN_DRAIN;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_4;
    ald_gpio_init(USART1_RX_PORT, USART1_RX_PIN, &gpio_config);
    
    return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_send_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_recv_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Send and receive a message complete.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_send_recv_complete(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to usart_handle_t structure.
  * @retval None.
  */
void usart_error(usart_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Enable usart interrupt */
    ald_mcu_irq_config(USART0_IRQn, 3, ENABLE);
    ald_mcu_irq_config(USART1_IRQn, 3, ENABLE);

    /* Initialize pin */
    init_usart_pin();

    memset(&g_usart0_handle, 0x00, sizeof(usart_handle_t));
    /* Initialize USART */
    g_usart0_handle.perh               = USART0;
    g_usart0_handle.init.baud          = 9600;
    g_usart0_handle.init.word_length   = USART_WORD_LENGTH_9B;
    g_usart0_handle.init.stop_bits     = USART_STOP_BITS_1;
    g_usart0_handle.init.parity        = USART_PARITY_NONE;
    g_usart0_handle.init.mode          = USART_MODE_TX_RX;
    g_usart0_handle.init.fctl          = USART_HW_FLOW_CTL_NONE;
    ald_usart_multi_processor_init(&g_usart0_handle, 0xF, USART_WAKEUP_ADDR);
    ald_usart_multi_processor_enter_mute_mode(&g_usart0_handle);

    memset(&g_usart1_handle, 0x00, sizeof(usart_handle_t));
    g_usart1_handle.perh               = USART1;
    g_usart1_handle.init.baud          = 9600;
    g_usart1_handle.init.word_length   = USART_WORD_LENGTH_9B;
    g_usart1_handle.init.stop_bits     = USART_STOP_BITS_1;
    g_usart1_handle.init.parity        = USART_PARITY_NONE;
    g_usart1_handle.init.mode          = USART_MODE_TX_RX;
    g_usart1_handle.init.fctl          = USART_HW_FLOW_CTL_NONE;
    ald_usart_multi_processor_init(&g_usart1_handle, 0x1, USART_WAKEUP_ADDR);
    ald_usart_multi_processor_enter_mute_mode(&g_usart1_handle);

    SET_BIT(USART0->CON0, USART_CON0_RXNEIE_MSK);
    SET_BIT(USART1->CON0, USART_CON0_RXNEIE_MSK);

    g_tx0_len = strlen((const char *)g_tx0_buf);
    g_tx1_len = strlen((const char *)g_tx1_buf);

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
