/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"
#include "utils.h"
#include "ald_cmu.h"
#ifdef ALD_DMA
    #include "ald_dma.h"
#endif    /*ALD_DMA*/

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uint8_t g_first_1 = 0U;
uint8_t g_first_0 = 0U;
/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    ald_inc_tick();
    return;
}

/**
  * @brief  CMU IRQ#4 handler
  * @retval None
  */
void CMU_Handler(void)
{
    ald_cmu_irq_handler();
    return;
}

#ifdef ALD_DMA
/**
  * @brief  DMA IRQ#9 handler
  * @retval None
  */
void DMA_Handler(void)
{
    ald_dma_irq_handler();
}
#endif    /*ALD_DMA*/

/**
  * @brief:  This function handles USART0 exception.
  * @param:  None
  * @retval: None
  */

void USART0_Handler(void)
{
    if ((READ_BIT(USART0->CON0, USART_CON0_RXNEIE_MSK) == (USART_CON0_RXNEIE_MSK)) && (READ_BIT(USART0->STAT, USART_STAT_RXNEIF_MSK) == (USART_STAT_RXNEIF_MSK)))
    {
        WRITE_REG(USART0->STAT, ~(USART_STAT_RXNEIF_MSK));

        if (g_first_0 == 0)
        {
            g_first_0++;
        }
        else
        {
            g_rx0_buf[g_rx0_i] = READ_BIT(USART0->DATA, USART_DATA_VAL_MSK);

            if ((g_rx0_i >= 1) && (g_rx0_buf[g_rx0_i - 1] == 0x0D) && (g_rx0_buf[g_rx0_i] == 0x0A))
            {
                memcpy(g_tx0_buf + g_tx0_len, g_rx0_buf, g_rx0_i + 1);
                SET_BIT(USART0->CON0, USART_CON0_TXEMPIE_MSK);
                g_first_0 = 0;
                return;
            }

            g_rx0_i++;

            if (g_rx0_i >= g_rx0_len)
            {
                g_rx0_i = 0;
            }
        }
    }

    if ((READ_BIT(USART0->CON0, USART_CON0_TXEMPIE_MSK) == (USART_CON0_TXEMPIE_MSK)) && (READ_BIT(USART0->STAT, USART_STAT_TXEMPIF_MSK) == (USART_STAT_TXEMPIF_MSK)))
    {

        if (g_tx0_i < g_tx0_len + g_rx0_i + 1)
        {
            USART0->DATA = g_tx0_buf[g_tx0_i++];
        }
        else
        {
            g_tx0_i = 0;
            g_rx0_i = 0;
            CLEAR_BIT(USART0->CON0, USART_CON0_TXEMPIE_MSK);
        }
    }
}

/**
  * @brief:  This function handles USART1 exception.
  * @param:  None
  * @retval: None
  */

void USART1_Handler(void)
{
    if ((READ_BIT(USART1->CON0, USART_CON0_RXNEIE_MSK) == (USART_CON0_RXNEIE_MSK)) && (READ_BIT(USART1->STAT, USART_STAT_RXNEIF_MSK) == (USART_STAT_RXNEIF_MSK)))
    {
        WRITE_REG(USART1->STAT, ~(USART_STAT_RXNEIF_MSK));

        if (g_first_1 == 0)
        {
            g_first_1++;
        }
        else
        {
            g_rx1_buf[g_rx1_i] = READ_BIT(USART1->DATA, USART_DATA_VAL_MSK);

            if ((g_rx1_i >= 1) && (g_rx1_buf[g_rx1_i - 1] == 0x0D) && (g_rx1_buf[g_rx1_i] == 0x0A))
            {
                memcpy(g_tx1_buf + g_tx1_len, g_rx1_buf, g_rx1_i + 1);
                SET_BIT(USART1->CON0, USART_CON0_TXEMPIE_MSK);
                g_first_1 = 0;
                return;
            }

            g_rx1_i++;

            if (g_rx1_i >= g_rx1_len)
            {
                g_rx1_i = 0;
            }
        }
    }

    if ((READ_BIT(USART1->CON0, USART_CON0_TXEMPIE_MSK) == (USART_CON0_TXEMPIE_MSK)) && (READ_BIT(USART1->STAT, USART_STAT_TXEMPIF_MSK) == (USART_STAT_TXEMPIF_MSK)))
    {

        if (g_tx1_i < g_tx1_len + g_rx1_i + 1)
        {
            USART1->DATA = g_tx1_buf[g_tx1_i++];
        }
        else
        {
            g_tx1_i = 0;
            g_rx1_i = 0;
            CLEAR_BIT(USART1->CON0, USART_CON0_TXEMPIE_MSK);
        }
    }
}
/**
  * @}
  */

/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
