/**********************************************************************************
 *
 * @file    lin.c
 * @brief   Head file for lin module
 *
 * @date    23 Sep 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Sep 2021     biyq          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __LIN_H
#define __LIN_H

/* Includes ------------------------------------------------------------------ */
#include "stdint.h"
#include "string.h"

/* Exported Macros ----------------------------------------------------------- */
#define LBRK_SEG    0x00
#define SYNC_SEG    0x55
#define BUF_SIZE    0x0F
#define CAL_BIT(A, B)   (((A) >> (B)) & 0x01)

/* Exported Types ------------------------------------------------------------ */
typedef enum lin_node_send_result_def
{
    PASS        = 0,
    FAIL        = 1,
    ON_GOING    = 2
} trans_result_t;

typedef enum lin_node_mode_def
{
    SLAVE  = 0,
    MASTER = 1
} node_mode_t;

typedef enum trans_direction_def
{
    L_READ          = 0,
    L_WRITE         = 1
} trans_dir_t;

typedef enum lin_node_state_def
{
    SLEEP           = 0,
    STANDBY         = 1,
    NORMAL_SLOPE    = 2,
    LOW_SLOPE       = 3
} node_state_t;

typedef enum lin_frame_status_def
{
    BREAKFIELD_STAGE    = 0,
    SYNC_STAGE          = 1,
    PID_STAGE           = 2,
    DATA_STAGE          = 3,
    CHECKSUM_STAGE      = 4
} frame_status_t;

typedef struct lin_node_def
{
    uint8_t         sync_field;
    uint8_t         id;
    uint32_t        checksum;
    uint32_t        data_len;
    uint32_t        baud;
    uint32_t        time_stamp1;
    uint32_t        time_stamp2;
    uint32_t        breakfield_time;
    trans_dir_t     dir;
    node_mode_t     node_mode;
    node_state_t    node_state;
    trans_result_t  send_result;
    trans_result_t  recv_result;
    frame_status_t  frame_status;
    uint8_t         trans_buf[BUF_SIZE];
    void (*node_wait_bk)(void);
    void (*node_send_bk_req)(void);
    void (*node_send_byte)(uint8_t);
    void (*node_recv_ctrl)(struct lin_node_def *);
    void (*node_enter_sleep)(void);
    void (*node_exit_sleep)(void);
    void (*node_normal_slope_mode)(void);
    void (*node_low_slope_mode)(void);
} lin_node_t;

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
uint8_t lin_pid_cal(uint8_t raw_pid);
uint8_t lin_cal_checksum(lin_node_t *lin_node, uint8_t *buf);
void lin_sendframe(lin_node_t *lin_node, uint8_t *buf, uint32_t len);
void lin_recvframe(lin_node_t *lin_node, uint32_t len);
void lin_chstat(lin_node_t *lin_node, node_state_t stat);
void lin_chfstat(lin_node_t *lin_node, frame_status_t status);
void lin_break_seg_proc(lin_node_t *lin_node);
void lin_recv_data_proc(lin_node_t *lin_node, uint8_t data);

#endif   /*__LIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/


