/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for demo
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"
#include "smart_card.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uint8_t g_tx_buf[32];

uint8_t g_rx_buf[32];

uint8_t g_SMART_CARD_OK = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Init UART pin
  * @retval None
  */
void uart_pin_init(void)
{
    md_gpio_init_t x;
    md_gpio_init_struct(&x);

    /* Initialize io(tx) pin */
    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.odos  = MD_GPIO_OPEN_DRAIN;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_3;
    md_gpio_init(CARD_IO_PORT, CARD_IO_PIN, &x);

    /* Initialize rst pin */
    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_1;
    md_gpio_init(CARD_RST_PORT, CARD_RST_PIN, &x);

    /* Initialize clk pin */
    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_3;
    md_gpio_init(CARD_CLK_PORT, CARD_CLK_PIN, &x);
}

/**
  * @brief:  Initialize the uart.
  * @param:  None
  * @retval: None
  */
void uart_init(void)
{
    md_uart_init_t h_uart;
    md_uart_init_struct(&h_uart);

    /* Initialize UART5 */
    h_uart.baud        = 16129;
    h_uart.word_length = MD_UART_WORD_LENGTH_8B;
    h_uart.stop_bits   = MD_UART_STOP_BITS_1_5;  /* stop bit: 1.5(in smart card mode only) */
    h_uart.parity      = MD_UART_PARITY_EVEN;
    h_uart.fctl        = MD_UART_FLOW_CTL_DISABLE;
    h_uart.mode        = MD_UART_MODE_SCARD;
    md_uart_init(UART5, &h_uart);

    md_uart_set_tx_threshold(UART5, MD_UART_TXFIFO_EMPTY);
    md_uart_set_rx_threshold(UART5, MD_UART_RXFIFO_1BYTE);

    md_uart_enable_scard_sclken(UART5);
    md_uart_enable_scard_nack(UART5);
    md_uart_set_scard_gt(UART5, 2);
    md_uart_set_scard_psc(UART5, 1);
    md_uart_enable_scard_mode(UART5);

    md_uart_clear_it_tbc(UART5);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint16_t cnt1, cnt2;
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 24000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    uart_pin_init();

    /* Init UART */
    uart_init();

    cnt1 = 4000;

    while ((reset_rec(g_rx_buf) == CARD_ERROR) && (--cnt1));

    cnt2 = 4000;

    while ((instruction_test() == CARD_ERROR) && (--cnt2));

    if (cnt1 > 0 && cnt2 > 0)
        g_SMART_CARD_OK = 1;

    while (1);
}


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
