/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for demo
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Init UART pin
  * @retval None
  */
void uart_pin_init(void)
{
    md_gpio_init_t x;
    md_gpio_init_struct(&x);

    /* Initialize tx pin: PC0 */
    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_3;
    md_gpio_init(UART1_TX_PORT, UART1_TX_PIN, &x);

    /* Initialize rx pin: PC1 */
    x.mode  = MD_GPIO_MODE_INPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_3;
    md_gpio_init(UART1_RX_PORT, UART1_RX_PIN, &x);
}

/**
  * @brief:  Initialize the uart.
  * @param:  None
  * @retval: None
  */
void uart_init(void)
{
    md_uart_init_t h_uart;
    md_uart_init_struct(&h_uart);

    /* Initialize UART1 */
    h_uart.baud        = 2400;
    h_uart.word_length = MD_UART_WORD_LENGTH_8B;
    h_uart.stop_bits   = MD_UART_STOP_BITS_1;
    h_uart.parity      = MD_UART_PARITY_NONE;
    h_uart.fctl        = MD_UART_FLOW_CTL_DISABLE;
    h_uart.mode        = MD_UART_MODE;
    md_uart_init(UART1, &h_uart);

    md_uart_set_tx_threshold(UART1, MD_UART_TXFIFO_EMPTY);
    md_uart_set_rx_threshold(UART1, MD_UART_RXFIFO_1BYTE);

    md_uart_enable_it_rfth(UART1);
    md_uart_enable_it_tfempty(UART1);
}

/**
  * @brief  Initialize TIMER.
  * @param  None
  * @retval None
  */
void timer_init(void)
{
    md_timer_base_init_t tim_init;
    md_timer_oc_init_t oc_init;
    md_timer_base_struct_init(&tim_init);
    md_timer_oc_struct_init(&oc_init);

    tim_init.prescaler   = 0;
    tim_init.mode        = MD_TIMER_CNT_MODE_UP;
    tim_init.period      = 1270;
    tim_init.clk_div     = MD_TIMER_CLOCK_DIV1;
    tim_init.re_cnt      = 0;
    md_timer_base_set_config(TIMER0, &tim_init);

    oc_init.ocstate = MD_TIMER_OCSTATE_ENABLE;
    oc_init.ocnstate = MD_TIMER_OCSTATE_ENABLE;
    oc_init.oc_mode = MD_TIMER_OC_MODE_PWM2;
    oc_init.oc_polarity = MD_TIMER_OC_POLARITY_HIGH;
    oc_init.ocn_polarity = MD_TIMER_OCN_POLARITY_HIGH;
    oc_init.oc_fast_en = DISABLE;
    oc_init.oc_idle = MD_TIMER_OC_IDLE_RESET;
    oc_init.ocn_idle = MD_TIMER_OCN_IDLE_RESET;
    oc_init.pulse = 635;
    md_timer_oc_init(TIMER0, MD_TIMER_CHANNEL_1, &oc_init);

    md_timer_set_main_output_enable(TIMER0, 1);
    md_timer_enable_counter_cnten(TIMER0);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    md_pis_set_uart1_mod_src(PIS, MD_PIS_SRC_TIMER0);
    md_pis_set_uart1_mod_tim_channel(PIS, MD_PIS_TIMER_CH1);
    md_pis_set_uart1_tx_mod_low(PIS);

    timer_init();

    md_mcu_irq_config(UART1_IRQn, 2, 2, ENABLE);

    uart_pin_init();

    uart_init();

    while (1)
    {
    }
}


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
