/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"
#include "md_utils.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */
char g_rx_buf[256];
uint32_t g_tx_len;
uint32_t g_tx_i = 0U;
uint32_t g_rx_len = sizeof(g_rx_buf);
uint32_t g_rx_i = 0U;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void UART1_Handler(void)
{
    uint16_t cnt;

    if (md_uart_mask_it_tfempty(UART1))
    {
        md_uart_clear_it_tfempty(UART1);

        cnt = 4000;

        while (md_uart_is_active_flag_tffull(UART1) && (--cnt));

        md_uart_set_send_data8(UART1, g_rx_buf[g_tx_i]);
        g_tx_i++;

        if (g_tx_i >= g_tx_len)
        {
            g_tx_i = 0;
            md_uart_disable_it_tfempty(UART1);
        }
    }

    if (md_uart_mask_it_rfth(UART1))
    {
        md_uart_clear_flag_rfth(UART1);

        cnt = 4000;

        while (!md_uart_is_active_flag_rfempty(UART1) && (--cnt))
        {
            g_rx_buf[g_rx_i] = md_uart_recv_data8(UART1);

            if (g_rx_buf[0] != 0x55) /* if the first byte is not 0x55("U"), re-detect baud. */
            {
                md_uart_set_abrmod(UART1, 0);
                md_uart_enable_abr(UART1);

                return;
            }

            if ((g_rx_i >= 1) && (g_rx_buf[g_rx_i - 1] == 0x0D) && (g_rx_buf[g_rx_i] == 0x0A))
            {
                g_tx_len = g_rx_i + 1;
                g_rx_i = 0;
                md_uart_enable_it_tfempty(UART1);
            }
            else
            {
                g_rx_i++;
            }

            if (g_rx_i >= g_rx_len)
                g_rx_i = 0;
        }
    }

    return;
}


/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
