/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"
#include "smart_card.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uart_handle_t g_h_uart;

uint8_t g_tx_buf[32];

uint8_t g_rx_buf[32];

uint8_t g_SMART_CARD_OK = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void uart_pin_init(void)
{
    gpio_init_t x;
    memset(&x, 0x00, sizeof(gpio_init_t));

    /* Initialize io(tx) pin: PA2 */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_OPEN_DRAIN;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_3;
    ald_gpio_init(CARD_IO_PORT, CARD_IO_PIN, &x);

    /* Initialize rst pin: PA1 */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_1;
    ald_gpio_init(CARD_RST_PORT, CARD_RST_PIN, &x);

    /* Initialize clk pin: PA4 */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_3;
    ald_gpio_init(CARD_CLK_PORT, CARD_CLK_PIN, &x);
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_send_complete(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_recv_complete(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_error(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint16_t cnt1, cnt2;
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_clock_config(CMU_CLOCK_HRC, 24000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Initialize pin */
    uart_pin_init();

    memset(&g_h_uart, 0x00, sizeof(uart_handle_t));
    /* Initialize uart */
    g_h_uart.perh             = UART5;
    g_h_uart.init.baud        = 16129;
    g_h_uart.init.word_length = UART_WORD_LENGTH_8B;
    g_h_uart.init.stop_bits   = UART_STOP_BITS_1_5;
    g_h_uart.init.parity      = UART_PARITY_EVEN;
    g_h_uart.init.mode        = UART_MODE_SCARD;
    g_h_uart.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&g_h_uart);

    ald_uart_rx_fifo_config(&g_h_uart, UART_RXFIFO_1BYTE);
    ald_uart_tx_fifo_config(&g_h_uart, UART_TXFIFO_EMPTY);

    UART_ENABLE_SCARD_CLK(&g_h_uart);
    UART_ENABLE_SCARD_NACK(&g_h_uart);
    MODIFY_REG(g_h_uart.perh->SCARD, UART_SCARD_GT_MSK, 2 << UART_SCARD_GT_POSS);
    MODIFY_REG(g_h_uart.perh->SCARD, UART_SCARD_PSC_MSK, 1 << UART_SCARD_PSC_POSS);
    UART_SCARD_ENABLE(&g_h_uart);
    ald_uart_clear_flag_status(&g_h_uart, UART_IF_TBC);

    cnt1 = 4000;

    while ((reset_rec(g_rx_buf) == CARD_ERROR) && (--cnt1));

    cnt2 = 4000;

    while ((instruction_test() == CARD_ERROR) && (--cnt2));

    if (cnt1 > 0 && cnt2 > 0)
        g_SMART_CARD_OK = 1;

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
