/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

#define CARD_IO_PORT    GPIOA
#define CARD_IO_PIN     GPIO_PIN_2
#define CARD_RST_PORT   GPIOA
#define CARD_RST_PIN    GPIO_PIN_1
#define CARD_CLK_PORT   GPIOA
#define CARD_CLK_PIN    GPIO_PIN_4

#define CARD_RST_L      CLEAR_BIT(CARD_RST_PORT->DOUT, CARD_RST_PIN);
#define CARD_RST_H      SET_BIT(CARD_RST_PORT->DOUT, CARD_RST_PIN);

/* Exported Variables -------------------------------------------------------- */

extern uart_handle_t g_h_uart;

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

#endif  /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
